/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information identifying the person picking up the device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PickupDetails implements SdkPojo, Serializable, ToCopyableBuilder<PickupDetails.Builder, PickupDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(PickupDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumber").getter(getter(PickupDetails::phoneNumber)).setter(setter(Builder::phoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()).build();

    private static final SdkField<String> EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Email")
            .getter(getter(PickupDetails::email)).setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()).build();

    private static final SdkField<String> IDENTIFICATION_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentificationNumber").getter(getter(PickupDetails::identificationNumber))
            .setter(setter(Builder::identificationNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentificationNumber").build())
            .build();

    private static final SdkField<Instant> IDENTIFICATION_EXPIRATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("IdentificationExpirationDate")
            .getter(getter(PickupDetails::identificationExpirationDate))
            .setter(setter(Builder::identificationExpirationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentificationExpirationDate")
                    .build()).build();

    private static final SdkField<String> IDENTIFICATION_ISSUING_ORG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentificationIssuingOrg").getter(getter(PickupDetails::identificationIssuingOrg))
            .setter(setter(Builder::identificationIssuingOrg))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentificationIssuingOrg").build())
            .build();

    private static final SdkField<String> DEVICE_PICKUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DevicePickupId").getter(getter(PickupDetails::devicePickupId)).setter(setter(Builder::devicePickupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DevicePickupId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            PHONE_NUMBER_FIELD, EMAIL_FIELD, IDENTIFICATION_NUMBER_FIELD, IDENTIFICATION_EXPIRATION_DATE_FIELD,
            IDENTIFICATION_ISSUING_ORG_FIELD, DEVICE_PICKUP_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String phoneNumber;

    private final String email;

    private final String identificationNumber;

    private final Instant identificationExpirationDate;

    private final String identificationIssuingOrg;

    private final String devicePickupId;

    private PickupDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.phoneNumber = builder.phoneNumber;
        this.email = builder.email;
        this.identificationNumber = builder.identificationNumber;
        this.identificationExpirationDate = builder.identificationExpirationDate;
        this.identificationIssuingOrg = builder.identificationIssuingOrg;
        this.devicePickupId = builder.devicePickupId;
    }

    /**
     * <p>
     * The name of the person picking up the device.
     * </p>
     * 
     * @return The name of the person picking up the device.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The phone number of the person picking up the device.
     * </p>
     * 
     * @return The phone number of the person picking up the device.
     */
    public final String phoneNumber() {
        return phoneNumber;
    }

    /**
     * <p>
     * The email address of the person picking up the device.
     * </p>
     * 
     * @return The email address of the person picking up the device.
     */
    public final String email() {
        return email;
    }

    /**
     * <p>
     * The number on the credential identifying the person picking up the device.
     * </p>
     * 
     * @return The number on the credential identifying the person picking up the device.
     */
    public final String identificationNumber() {
        return identificationNumber;
    }

    /**
     * <p>
     * Expiration date of the credential identifying the person picking up the device.
     * </p>
     * 
     * @return Expiration date of the credential identifying the person picking up the device.
     */
    public final Instant identificationExpirationDate() {
        return identificationExpirationDate;
    }

    /**
     * <p>
     * Organization that issued the credential identifying the person picking up the device.
     * </p>
     * 
     * @return Organization that issued the credential identifying the person picking up the device.
     */
    public final String identificationIssuingOrg() {
        return identificationIssuingOrg;
    }

    /**
     * <p>
     * The unique ID for a device that will be picked up.
     * </p>
     * 
     * @return The unique ID for a device that will be picked up.
     */
    public final String devicePickupId() {
        return devicePickupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        hashCode = 31 * hashCode + Objects.hashCode(identificationNumber());
        hashCode = 31 * hashCode + Objects.hashCode(identificationExpirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(identificationIssuingOrg());
        hashCode = 31 * hashCode + Objects.hashCode(devicePickupId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PickupDetails)) {
            return false;
        }
        PickupDetails other = (PickupDetails) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(phoneNumber(), other.phoneNumber())
                && Objects.equals(email(), other.email()) && Objects.equals(identificationNumber(), other.identificationNumber())
                && Objects.equals(identificationExpirationDate(), other.identificationExpirationDate())
                && Objects.equals(identificationIssuingOrg(), other.identificationIssuingOrg())
                && Objects.equals(devicePickupId(), other.devicePickupId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PickupDetails").add("Name", name())
                .add("PhoneNumber", phoneNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Email", email() == null ? null : "*** Sensitive Data Redacted ***")
                .add("IdentificationNumber", identificationNumber())
                .add("IdentificationExpirationDate", identificationExpirationDate())
                .add("IdentificationIssuingOrg", identificationIssuingOrg()).add("DevicePickupId", devicePickupId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "PhoneNumber":
            return Optional.ofNullable(clazz.cast(phoneNumber()));
        case "Email":
            return Optional.ofNullable(clazz.cast(email()));
        case "IdentificationNumber":
            return Optional.ofNullable(clazz.cast(identificationNumber()));
        case "IdentificationExpirationDate":
            return Optional.ofNullable(clazz.cast(identificationExpirationDate()));
        case "IdentificationIssuingOrg":
            return Optional.ofNullable(clazz.cast(identificationIssuingOrg()));
        case "DevicePickupId":
            return Optional.ofNullable(clazz.cast(devicePickupId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("PhoneNumber", PHONE_NUMBER_FIELD);
        map.put("Email", EMAIL_FIELD);
        map.put("IdentificationNumber", IDENTIFICATION_NUMBER_FIELD);
        map.put("IdentificationExpirationDate", IDENTIFICATION_EXPIRATION_DATE_FIELD);
        map.put("IdentificationIssuingOrg", IDENTIFICATION_ISSUING_ORG_FIELD);
        map.put("DevicePickupId", DEVICE_PICKUP_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PickupDetails, T> g) {
        return obj -> g.apply((PickupDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PickupDetails> {
        /**
         * <p>
         * The name of the person picking up the device.
         * </p>
         * 
         * @param name
         *        The name of the person picking up the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The phone number of the person picking up the device.
         * </p>
         * 
         * @param phoneNumber
         *        The phone number of the person picking up the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(String phoneNumber);

        /**
         * <p>
         * The email address of the person picking up the device.
         * </p>
         * 
         * @param email
         *        The email address of the person picking up the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);

        /**
         * <p>
         * The number on the credential identifying the person picking up the device.
         * </p>
         * 
         * @param identificationNumber
         *        The number on the credential identifying the person picking up the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identificationNumber(String identificationNumber);

        /**
         * <p>
         * Expiration date of the credential identifying the person picking up the device.
         * </p>
         * 
         * @param identificationExpirationDate
         *        Expiration date of the credential identifying the person picking up the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identificationExpirationDate(Instant identificationExpirationDate);

        /**
         * <p>
         * Organization that issued the credential identifying the person picking up the device.
         * </p>
         * 
         * @param identificationIssuingOrg
         *        Organization that issued the credential identifying the person picking up the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identificationIssuingOrg(String identificationIssuingOrg);

        /**
         * <p>
         * The unique ID for a device that will be picked up.
         * </p>
         * 
         * @param devicePickupId
         *        The unique ID for a device that will be picked up.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devicePickupId(String devicePickupId);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String phoneNumber;

        private String email;

        private String identificationNumber;

        private Instant identificationExpirationDate;

        private String identificationIssuingOrg;

        private String devicePickupId;

        private BuilderImpl() {
        }

        private BuilderImpl(PickupDetails model) {
            name(model.name);
            phoneNumber(model.phoneNumber);
            email(model.email);
            identificationNumber(model.identificationNumber);
            identificationExpirationDate(model.identificationExpirationDate);
            identificationIssuingOrg(model.identificationIssuingOrg);
            devicePickupId(model.devicePickupId);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPhoneNumber() {
            return phoneNumber;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final String getEmail() {
            return email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final String getIdentificationNumber() {
            return identificationNumber;
        }

        public final void setIdentificationNumber(String identificationNumber) {
            this.identificationNumber = identificationNumber;
        }

        @Override
        public final Builder identificationNumber(String identificationNumber) {
            this.identificationNumber = identificationNumber;
            return this;
        }

        public final Instant getIdentificationExpirationDate() {
            return identificationExpirationDate;
        }

        public final void setIdentificationExpirationDate(Instant identificationExpirationDate) {
            this.identificationExpirationDate = identificationExpirationDate;
        }

        @Override
        public final Builder identificationExpirationDate(Instant identificationExpirationDate) {
            this.identificationExpirationDate = identificationExpirationDate;
            return this;
        }

        public final String getIdentificationIssuingOrg() {
            return identificationIssuingOrg;
        }

        public final void setIdentificationIssuingOrg(String identificationIssuingOrg) {
            this.identificationIssuingOrg = identificationIssuingOrg;
        }

        @Override
        public final Builder identificationIssuingOrg(String identificationIssuingOrg) {
            this.identificationIssuingOrg = identificationIssuingOrg;
            return this;
        }

        public final String getDevicePickupId() {
            return devicePickupId;
        }

        public final void setDevicePickupId(String devicePickupId) {
            this.devicePickupId = devicePickupId;
        }

        @Override
        public final Builder devicePickupId(String devicePickupId) {
            this.devicePickupId = devicePickupId;
            return this;
        }

        @Override
        public PickupDetails build() {
            return new PickupDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
