/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class S3ResourceListCopier {
    static List<S3Resource> copy(Collection<? extends S3Resource> s3ResourceListParam) {
        List<S3Resource> list;
        if (s3ResourceListParam == null || s3ResourceListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<S3Resource> modifiableList = new ArrayList<>(s3ResourceListParam.size());
            s3ResourceListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<S3Resource> copyFromBuilder(Collection<? extends S3Resource.Builder> s3ResourceListParam) {
        List<S3Resource> list;
        if (s3ResourceListParam == null || s3ResourceListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<S3Resource> modifiableList = new ArrayList<>(s3ResourceListParam.size());
            s3ResourceListParam.forEach(entry -> {
                S3Resource member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<S3Resource.Builder> copyToBuilder(Collection<? extends S3Resource> s3ResourceListParam) {
        List<S3Resource.Builder> list;
        if (s3ResourceListParam == null || s3ResourceListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<S3Resource.Builder> modifiableList = new ArrayList<>(s3ResourceListParam.size());
            s3ResourceListParam.forEach(entry -> {
                S3Resource.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
