/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the service or services on the Snow Family device that your transferred data will be
 * exported from or imported into. Amazon Web Services Snow Family supports Amazon S3 and NFS (Network File System).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetOnDeviceService implements SdkPojo, Serializable,
        ToCopyableBuilder<TargetOnDeviceService.Builder, TargetOnDeviceService> {
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceName").getter(getter(TargetOnDeviceService::serviceNameAsString))
            .setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()).build();

    private static final SdkField<String> TRANSFER_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransferOption").getter(getter(TargetOnDeviceService::transferOptionAsString))
            .setter(setter(Builder::transferOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransferOption").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAME_FIELD,
            TRANSFER_OPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String serviceName;

    private final String transferOption;

    private TargetOnDeviceService(BuilderImpl builder) {
        this.serviceName = builder.serviceName;
        this.transferOption = builder.transferOption;
    }

    /**
     * <p>
     * Specifies the name of the service on the Snow Family device that your transferred data will be exported from or
     * imported into.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceName} will
     * return {@link DeviceServiceName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceNameAsString}.
     * </p>
     * 
     * @return Specifies the name of the service on the Snow Family device that your transferred data will be exported
     *         from or imported into.
     * @see DeviceServiceName
     */
    public final DeviceServiceName serviceName() {
        return DeviceServiceName.fromValue(serviceName);
    }

    /**
     * <p>
     * Specifies the name of the service on the Snow Family device that your transferred data will be exported from or
     * imported into.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceName} will
     * return {@link DeviceServiceName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceNameAsString}.
     * </p>
     * 
     * @return Specifies the name of the service on the Snow Family device that your transferred data will be exported
     *         from or imported into.
     * @see DeviceServiceName
     */
    public final String serviceNameAsString() {
        return serviceName;
    }

    /**
     * <p>
     * Specifies whether the data is being imported or exported. You can import or export the data, or use it locally on
     * the device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #transferOption}
     * will return {@link TransferOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #transferOptionAsString}.
     * </p>
     * 
     * @return Specifies whether the data is being imported or exported. You can import or export the data, or use it
     *         locally on the device.
     * @see TransferOption
     */
    public final TransferOption transferOption() {
        return TransferOption.fromValue(transferOption);
    }

    /**
     * <p>
     * Specifies whether the data is being imported or exported. You can import or export the data, or use it locally on
     * the device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #transferOption}
     * will return {@link TransferOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #transferOptionAsString}.
     * </p>
     * 
     * @return Specifies whether the data is being imported or exported. You can import or export the data, or use it
     *         locally on the device.
     * @see TransferOption
     */
    public final String transferOptionAsString() {
        return transferOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(transferOptionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetOnDeviceService)) {
            return false;
        }
        TargetOnDeviceService other = (TargetOnDeviceService) obj;
        return Objects.equals(serviceNameAsString(), other.serviceNameAsString())
                && Objects.equals(transferOptionAsString(), other.transferOptionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetOnDeviceService").add("ServiceName", serviceNameAsString())
                .add("TransferOption", transferOptionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceName":
            return Optional.ofNullable(clazz.cast(serviceNameAsString()));
        case "TransferOption":
            return Optional.ofNullable(clazz.cast(transferOptionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ServiceName", SERVICE_NAME_FIELD);
        map.put("TransferOption", TRANSFER_OPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TargetOnDeviceService, T> g) {
        return obj -> g.apply((TargetOnDeviceService) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetOnDeviceService> {
        /**
         * <p>
         * Specifies the name of the service on the Snow Family device that your transferred data will be exported from
         * or imported into.
         * </p>
         * 
         * @param serviceName
         *        Specifies the name of the service on the Snow Family device that your transferred data will be
         *        exported from or imported into.
         * @see DeviceServiceName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceServiceName
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * Specifies the name of the service on the Snow Family device that your transferred data will be exported from
         * or imported into.
         * </p>
         * 
         * @param serviceName
         *        Specifies the name of the service on the Snow Family device that your transferred data will be
         *        exported from or imported into.
         * @see DeviceServiceName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceServiceName
         */
        Builder serviceName(DeviceServiceName serviceName);

        /**
         * <p>
         * Specifies whether the data is being imported or exported. You can import or export the data, or use it
         * locally on the device.
         * </p>
         * 
         * @param transferOption
         *        Specifies whether the data is being imported or exported. You can import or export the data, or use it
         *        locally on the device.
         * @see TransferOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransferOption
         */
        Builder transferOption(String transferOption);

        /**
         * <p>
         * Specifies whether the data is being imported or exported. You can import or export the data, or use it
         * locally on the device.
         * </p>
         * 
         * @param transferOption
         *        Specifies whether the data is being imported or exported. You can import or export the data, or use it
         *        locally on the device.
         * @see TransferOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransferOption
         */
        Builder transferOption(TransferOption transferOption);
    }

    static final class BuilderImpl implements Builder {
        private String serviceName;

        private String transferOption;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetOnDeviceService model) {
            serviceName(model.serviceName);
            transferOption(model.transferOption);
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @Override
        public final Builder serviceName(DeviceServiceName serviceName) {
            this.serviceName(serviceName == null ? null : serviceName.toString());
            return this;
        }

        public final String getTransferOption() {
            return transferOption;
        }

        public final void setTransferOption(String transferOption) {
            this.transferOption = transferOption;
        }

        @Override
        public final Builder transferOption(String transferOption) {
            this.transferOption = transferOption;
            return this;
        }

        @Override
        public final Builder transferOption(TransferOption transferOption) {
            this.transferOption(transferOption == null ? null : transferOption.toString());
            return this;
        }

        @Override
        public TargetOnDeviceService build() {
            return new TargetOnDeviceService(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
