/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateClusterRequest extends SnowballRequest implements
        ToCopyableBuilder<UpdateClusterRequest.Builder, UpdateClusterRequest> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterId").getter(getter(UpdateClusterRequest::clusterId)).setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleARN").getter(getter(UpdateClusterRequest::roleARN)).setter(setter(Builder::roleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateClusterRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<JobResource> RESOURCES_FIELD = SdkField.<JobResource> builder(MarshallingType.SDK_POJO)
            .memberName("Resources").getter(getter(UpdateClusterRequest::resources)).setter(setter(Builder::resources))
            .constructor(JobResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build()).build();

    private static final SdkField<OnDeviceServiceConfiguration> ON_DEVICE_SERVICE_CONFIGURATION_FIELD = SdkField
            .<OnDeviceServiceConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("OnDeviceServiceConfiguration")
            .getter(getter(UpdateClusterRequest::onDeviceServiceConfiguration))
            .setter(setter(Builder::onDeviceServiceConfiguration))
            .constructor(OnDeviceServiceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDeviceServiceConfiguration")
                    .build()).build();

    private static final SdkField<String> ADDRESS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddressId").getter(getter(UpdateClusterRequest::addressId)).setter(setter(Builder::addressId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressId").build()).build();

    private static final SdkField<String> SHIPPING_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShippingOption").getter(getter(UpdateClusterRequest::shippingOptionAsString))
            .setter(setter(Builder::shippingOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShippingOption").build()).build();

    private static final SdkField<Notification> NOTIFICATION_FIELD = SdkField.<Notification> builder(MarshallingType.SDK_POJO)
            .memberName("Notification").getter(getter(UpdateClusterRequest::notification)).setter(setter(Builder::notification))
            .constructor(Notification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notification").build()).build();

    private static final SdkField<String> FORWARDING_ADDRESS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ForwardingAddressId").getter(getter(UpdateClusterRequest::forwardingAddressId))
            .setter(setter(Builder::forwardingAddressId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForwardingAddressId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD,
            ROLE_ARN_FIELD, DESCRIPTION_FIELD, RESOURCES_FIELD, ON_DEVICE_SERVICE_CONFIGURATION_FIELD, ADDRESS_ID_FIELD,
            SHIPPING_OPTION_FIELD, NOTIFICATION_FIELD, FORWARDING_ADDRESS_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterId;

    private final String roleARN;

    private final String description;

    private final JobResource resources;

    private final OnDeviceServiceConfiguration onDeviceServiceConfiguration;

    private final String addressId;

    private final String shippingOption;

    private final Notification notification;

    private final String forwardingAddressId;

    private UpdateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.roleARN = builder.roleARN;
        this.description = builder.description;
        this.resources = builder.resources;
        this.onDeviceServiceConfiguration = builder.onDeviceServiceConfiguration;
        this.addressId = builder.addressId;
        this.shippingOption = builder.shippingOption;
        this.notification = builder.notification;
        this.forwardingAddressId = builder.forwardingAddressId;
    }

    /**
     * <p>
     * The cluster ID of the cluster that you want to update, for example
     * <code>CID123e4567-e89b-12d3-a456-426655440000</code>.
     * </p>
     * 
     * @return The cluster ID of the cluster that you want to update, for example
     *         <code>CID123e4567-e89b-12d3-a456-426655440000</code>.
     */
    public final String clusterId() {
        return clusterId;
    }

    /**
     * <p>
     * The new role Amazon Resource Name (ARN) that you want to associate with this cluster. To create a role ARN, use
     * the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action
     * in Identity and Access Management (IAM).
     * </p>
     * 
     * @return The new role Amazon Resource Name (ARN) that you want to associate with this cluster. To create a role
     *         ARN, use the <a
     *         href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action
     *         in Identity and Access Management (IAM).
     */
    public final String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * The updated description of this cluster.
     * </p>
     * 
     * @return The updated description of this cluster.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The updated arrays of <a>JobResource</a> objects that can include updated <a>S3Resource</a> objects or
     * <a>LambdaResource</a> objects.
     * </p>
     * 
     * @return The updated arrays of <a>JobResource</a> objects that can include updated <a>S3Resource</a> objects or
     *         <a>LambdaResource</a> objects.
     */
    public final JobResource resources() {
        return resources;
    }

    /**
     * <p>
     * Specifies the service or services on the Snow Family device that your transferred data will be exported from or
     * imported into. Amazon Web Services Snow Family device clusters support Amazon S3 and NFS (Network File System).
     * </p>
     * 
     * @return Specifies the service or services on the Snow Family device that your transferred data will be exported
     *         from or imported into. Amazon Web Services Snow Family device clusters support Amazon S3 and NFS (Network
     *         File System).
     */
    public final OnDeviceServiceConfiguration onDeviceServiceConfiguration() {
        return onDeviceServiceConfiguration;
    }

    /**
     * <p>
     * The ID of the updated <a>Address</a> object.
     * </p>
     * 
     * @return The ID of the updated <a>Address</a> object.
     */
    public final String addressId() {
        return addressId;
    }

    /**
     * <p>
     * The updated shipping option value of this cluster's <a>ShippingDetails</a> object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shippingOption}
     * will return {@link ShippingOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #shippingOptionAsString}.
     * </p>
     * 
     * @return The updated shipping option value of this cluster's <a>ShippingDetails</a> object.
     * @see ShippingOption
     */
    public final ShippingOption shippingOption() {
        return ShippingOption.fromValue(shippingOption);
    }

    /**
     * <p>
     * The updated shipping option value of this cluster's <a>ShippingDetails</a> object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shippingOption}
     * will return {@link ShippingOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #shippingOptionAsString}.
     * </p>
     * 
     * @return The updated shipping option value of this cluster's <a>ShippingDetails</a> object.
     * @see ShippingOption
     */
    public final String shippingOptionAsString() {
        return shippingOption;
    }

    /**
     * <p>
     * The new or updated <a>Notification</a> object.
     * </p>
     * 
     * @return The new or updated <a>Notification</a> object.
     */
    public final Notification notification() {
        return notification;
    }

    /**
     * <p>
     * The updated ID for the forwarding address for a cluster. This field is not supported in most regions.
     * </p>
     * 
     * @return The updated ID for the forwarding address for a cluster. This field is not supported in most regions.
     */
    public final String forwardingAddressId() {
        return forwardingAddressId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(resources());
        hashCode = 31 * hashCode + Objects.hashCode(onDeviceServiceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(addressId());
        hashCode = 31 * hashCode + Objects.hashCode(shippingOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(notification());
        hashCode = 31 * hashCode + Objects.hashCode(forwardingAddressId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateClusterRequest)) {
            return false;
        }
        UpdateClusterRequest other = (UpdateClusterRequest) obj;
        return Objects.equals(clusterId(), other.clusterId()) && Objects.equals(roleARN(), other.roleARN())
                && Objects.equals(description(), other.description()) && Objects.equals(resources(), other.resources())
                && Objects.equals(onDeviceServiceConfiguration(), other.onDeviceServiceConfiguration())
                && Objects.equals(addressId(), other.addressId())
                && Objects.equals(shippingOptionAsString(), other.shippingOptionAsString())
                && Objects.equals(notification(), other.notification())
                && Objects.equals(forwardingAddressId(), other.forwardingAddressId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateClusterRequest").add("ClusterId", clusterId()).add("RoleARN", roleARN())
                .add("Description", description()).add("Resources", resources())
                .add("OnDeviceServiceConfiguration", onDeviceServiceConfiguration()).add("AddressId", addressId())
                .add("ShippingOption", shippingOptionAsString()).add("Notification", notification())
                .add("ForwardingAddressId", forwardingAddressId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        case "RoleARN":
            return Optional.ofNullable(clazz.cast(roleARN()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Resources":
            return Optional.ofNullable(clazz.cast(resources()));
        case "OnDeviceServiceConfiguration":
            return Optional.ofNullable(clazz.cast(onDeviceServiceConfiguration()));
        case "AddressId":
            return Optional.ofNullable(clazz.cast(addressId()));
        case "ShippingOption":
            return Optional.ofNullable(clazz.cast(shippingOptionAsString()));
        case "Notification":
            return Optional.ofNullable(clazz.cast(notification()));
        case "ForwardingAddressId":
            return Optional.ofNullable(clazz.cast(forwardingAddressId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClusterId", CLUSTER_ID_FIELD);
        map.put("RoleARN", ROLE_ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Resources", RESOURCES_FIELD);
        map.put("OnDeviceServiceConfiguration", ON_DEVICE_SERVICE_CONFIGURATION_FIELD);
        map.put("AddressId", ADDRESS_ID_FIELD);
        map.put("ShippingOption", SHIPPING_OPTION_FIELD);
        map.put("Notification", NOTIFICATION_FIELD);
        map.put("ForwardingAddressId", FORWARDING_ADDRESS_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateClusterRequest, T> g) {
        return obj -> g.apply((UpdateClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnowballRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateClusterRequest> {
        /**
         * <p>
         * The cluster ID of the cluster that you want to update, for example
         * <code>CID123e4567-e89b-12d3-a456-426655440000</code>.
         * </p>
         * 
         * @param clusterId
         *        The cluster ID of the cluster that you want to update, for example
         *        <code>CID123e4567-e89b-12d3-a456-426655440000</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * <p>
         * The new role Amazon Resource Name (ARN) that you want to associate with this cluster. To create a role ARN,
         * use the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API
         * action in Identity and Access Management (IAM).
         * </p>
         * 
         * @param roleARN
         *        The new role Amazon Resource Name (ARN) that you want to associate with this cluster. To create a role
         *        ARN, use the <a
         *        href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API
         *        action in Identity and Access Management (IAM).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * The updated description of this cluster.
         * </p>
         * 
         * @param description
         *        The updated description of this cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The updated arrays of <a>JobResource</a> objects that can include updated <a>S3Resource</a> objects or
         * <a>LambdaResource</a> objects.
         * </p>
         * 
         * @param resources
         *        The updated arrays of <a>JobResource</a> objects that can include updated <a>S3Resource</a> objects or
         *        <a>LambdaResource</a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(JobResource resources);

        /**
         * <p>
         * The updated arrays of <a>JobResource</a> objects that can include updated <a>S3Resource</a> objects or
         * <a>LambdaResource</a> objects.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobResource.Builder} avoiding the need to
         * create one manually via {@link JobResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobResource.Builder#build()} is called immediately and its result
         * is passed to {@link #resources(JobResource)}.
         * 
         * @param resources
         *        a consumer that will call methods on {@link JobResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resources(JobResource)
         */
        default Builder resources(Consumer<JobResource.Builder> resources) {
            return resources(JobResource.builder().applyMutation(resources).build());
        }

        /**
         * <p>
         * Specifies the service or services on the Snow Family device that your transferred data will be exported from
         * or imported into. Amazon Web Services Snow Family device clusters support Amazon S3 and NFS (Network File
         * System).
         * </p>
         * 
         * @param onDeviceServiceConfiguration
         *        Specifies the service or services on the Snow Family device that your transferred data will be
         *        exported from or imported into. Amazon Web Services Snow Family device clusters support Amazon S3 and
         *        NFS (Network File System).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDeviceServiceConfiguration(OnDeviceServiceConfiguration onDeviceServiceConfiguration);

        /**
         * <p>
         * Specifies the service or services on the Snow Family device that your transferred data will be exported from
         * or imported into. Amazon Web Services Snow Family device clusters support Amazon S3 and NFS (Network File
         * System).
         * </p>
         * This is a convenience method that creates an instance of the {@link OnDeviceServiceConfiguration.Builder}
         * avoiding the need to create one manually via {@link OnDeviceServiceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OnDeviceServiceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #onDeviceServiceConfiguration(OnDeviceServiceConfiguration)}.
         * 
         * @param onDeviceServiceConfiguration
         *        a consumer that will call methods on {@link OnDeviceServiceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onDeviceServiceConfiguration(OnDeviceServiceConfiguration)
         */
        default Builder onDeviceServiceConfiguration(Consumer<OnDeviceServiceConfiguration.Builder> onDeviceServiceConfiguration) {
            return onDeviceServiceConfiguration(OnDeviceServiceConfiguration.builder()
                    .applyMutation(onDeviceServiceConfiguration).build());
        }

        /**
         * <p>
         * The ID of the updated <a>Address</a> object.
         * </p>
         * 
         * @param addressId
         *        The ID of the updated <a>Address</a> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressId(String addressId);

        /**
         * <p>
         * The updated shipping option value of this cluster's <a>ShippingDetails</a> object.
         * </p>
         * 
         * @param shippingOption
         *        The updated shipping option value of this cluster's <a>ShippingDetails</a> object.
         * @see ShippingOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShippingOption
         */
        Builder shippingOption(String shippingOption);

        /**
         * <p>
         * The updated shipping option value of this cluster's <a>ShippingDetails</a> object.
         * </p>
         * 
         * @param shippingOption
         *        The updated shipping option value of this cluster's <a>ShippingDetails</a> object.
         * @see ShippingOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShippingOption
         */
        Builder shippingOption(ShippingOption shippingOption);

        /**
         * <p>
         * The new or updated <a>Notification</a> object.
         * </p>
         * 
         * @param notification
         *        The new or updated <a>Notification</a> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notification(Notification notification);

        /**
         * <p>
         * The new or updated <a>Notification</a> object.
         * </p>
         * This is a convenience method that creates an instance of the {@link Notification.Builder} avoiding the need
         * to create one manually via {@link Notification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Notification.Builder#build()} is called immediately and its
         * result is passed to {@link #notification(Notification)}.
         * 
         * @param notification
         *        a consumer that will call methods on {@link Notification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notification(Notification)
         */
        default Builder notification(Consumer<Notification.Builder> notification) {
            return notification(Notification.builder().applyMutation(notification).build());
        }

        /**
         * <p>
         * The updated ID for the forwarding address for a cluster. This field is not supported in most regions.
         * </p>
         * 
         * @param forwardingAddressId
         *        The updated ID for the forwarding address for a cluster. This field is not supported in most regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forwardingAddressId(String forwardingAddressId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SnowballRequest.BuilderImpl implements Builder {
        private String clusterId;

        private String roleARN;

        private String description;

        private JobResource resources;

        private OnDeviceServiceConfiguration onDeviceServiceConfiguration;

        private String addressId;

        private String shippingOption;

        private Notification notification;

        private String forwardingAddressId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateClusterRequest model) {
            super(model);
            clusterId(model.clusterId);
            roleARN(model.roleARN);
            description(model.description);
            resources(model.resources);
            onDeviceServiceConfiguration(model.onDeviceServiceConfiguration);
            addressId(model.addressId);
            shippingOption(model.shippingOption);
            notification(model.notification);
            forwardingAddressId(model.forwardingAddressId);
        }

        public final String getClusterId() {
            return clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final JobResource.Builder getResources() {
            return resources != null ? resources.toBuilder() : null;
        }

        public final void setResources(JobResource.BuilderImpl resources) {
            this.resources = resources != null ? resources.build() : null;
        }

        @Override
        public final Builder resources(JobResource resources) {
            this.resources = resources;
            return this;
        }

        public final OnDeviceServiceConfiguration.Builder getOnDeviceServiceConfiguration() {
            return onDeviceServiceConfiguration != null ? onDeviceServiceConfiguration.toBuilder() : null;
        }

        public final void setOnDeviceServiceConfiguration(OnDeviceServiceConfiguration.BuilderImpl onDeviceServiceConfiguration) {
            this.onDeviceServiceConfiguration = onDeviceServiceConfiguration != null ? onDeviceServiceConfiguration.build()
                    : null;
        }

        @Override
        public final Builder onDeviceServiceConfiguration(OnDeviceServiceConfiguration onDeviceServiceConfiguration) {
            this.onDeviceServiceConfiguration = onDeviceServiceConfiguration;
            return this;
        }

        public final String getAddressId() {
            return addressId;
        }

        public final void setAddressId(String addressId) {
            this.addressId = addressId;
        }

        @Override
        public final Builder addressId(String addressId) {
            this.addressId = addressId;
            return this;
        }

        public final String getShippingOption() {
            return shippingOption;
        }

        public final void setShippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
        }

        @Override
        public final Builder shippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
            return this;
        }

        @Override
        public final Builder shippingOption(ShippingOption shippingOption) {
            this.shippingOption(shippingOption == null ? null : shippingOption.toString());
            return this;
        }

        public final Notification.Builder getNotification() {
            return notification != null ? notification.toBuilder() : null;
        }

        public final void setNotification(Notification.BuilderImpl notification) {
            this.notification = notification != null ? notification.build() : null;
        }

        @Override
        public final Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public final String getForwardingAddressId() {
            return forwardingAddressId;
        }

        public final void setForwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
        }

        @Override
        public final Builder forwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateClusterRequest build() {
            return new UpdateClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
