/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PickupDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PickupDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(PickupDetails.getter(PickupDetails::name)).setter(PickupDetails.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneNumber").getter(PickupDetails.getter(PickupDetails::phoneNumber)).setter(PickupDetails.setter(Builder::phoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()}).build();
    private static final SdkField<String> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Email").getter(PickupDetails.getter(PickupDetails::email)).setter(PickupDetails.setter(Builder::email)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()}).build();
    private static final SdkField<String> IDENTIFICATION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentificationNumber").getter(PickupDetails.getter(PickupDetails::identificationNumber)).setter(PickupDetails.setter(Builder::identificationNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentificationNumber").build()}).build();
    private static final SdkField<Instant> IDENTIFICATION_EXPIRATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("IdentificationExpirationDate").getter(PickupDetails.getter(PickupDetails::identificationExpirationDate)).setter(PickupDetails.setter(Builder::identificationExpirationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentificationExpirationDate").build()}).build();
    private static final SdkField<String> IDENTIFICATION_ISSUING_ORG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentificationIssuingOrg").getter(PickupDetails.getter(PickupDetails::identificationIssuingOrg)).setter(PickupDetails.setter(Builder::identificationIssuingOrg)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentificationIssuingOrg").build()}).build();
    private static final SdkField<String> DEVICE_PICKUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DevicePickupId").getter(PickupDetails.getter(PickupDetails::devicePickupId)).setter(PickupDetails.setter(Builder::devicePickupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DevicePickupId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PHONE_NUMBER_FIELD, EMAIL_FIELD, IDENTIFICATION_NUMBER_FIELD, IDENTIFICATION_EXPIRATION_DATE_FIELD, IDENTIFICATION_ISSUING_ORG_FIELD, DEVICE_PICKUP_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PickupDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String phoneNumber;
    private final String email;
    private final String identificationNumber;
    private final Instant identificationExpirationDate;
    private final String identificationIssuingOrg;
    private final String devicePickupId;

    private PickupDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.phoneNumber = builder.phoneNumber;
        this.email = builder.email;
        this.identificationNumber = builder.identificationNumber;
        this.identificationExpirationDate = builder.identificationExpirationDate;
        this.identificationIssuingOrg = builder.identificationIssuingOrg;
        this.devicePickupId = builder.devicePickupId;
    }

    public final String name() {
        return this.name;
    }

    public final String phoneNumber() {
        return this.phoneNumber;
    }

    public final String email() {
        return this.email;
    }

    public final String identificationNumber() {
        return this.identificationNumber;
    }

    public final Instant identificationExpirationDate() {
        return this.identificationExpirationDate;
    }

    public final String identificationIssuingOrg() {
        return this.identificationIssuingOrg;
    }

    public final String devicePickupId() {
        return this.devicePickupId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        hashCode = 31 * hashCode + Objects.hashCode(this.identificationNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.identificationExpirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.identificationIssuingOrg());
        hashCode = 31 * hashCode + Objects.hashCode(this.devicePickupId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PickupDetails)) {
            return false;
        }
        PickupDetails other = (PickupDetails)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.phoneNumber(), other.phoneNumber()) && Objects.equals(this.email(), other.email()) && Objects.equals(this.identificationNumber(), other.identificationNumber()) && Objects.equals(this.identificationExpirationDate(), other.identificationExpirationDate()) && Objects.equals(this.identificationIssuingOrg(), other.identificationIssuingOrg()) && Objects.equals(this.devicePickupId(), other.devicePickupId());
    }

    public final String toString() {
        return ToString.builder((String)"PickupDetails").add("Name", (Object)this.name()).add("PhoneNumber", (Object)(this.phoneNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("Email", (Object)(this.email() == null ? null : "*** Sensitive Data Redacted ***")).add("IdentificationNumber", (Object)this.identificationNumber()).add("IdentificationExpirationDate", (Object)this.identificationExpirationDate()).add("IdentificationIssuingOrg", (Object)this.identificationIssuingOrg()).add("DevicePickupId", (Object)this.devicePickupId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "PhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.phoneNumber()));
            }
            case "Email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
            case "IdentificationNumber": {
                return Optional.ofNullable(clazz.cast(this.identificationNumber()));
            }
            case "IdentificationExpirationDate": {
                return Optional.ofNullable(clazz.cast(this.identificationExpirationDate()));
            }
            case "IdentificationIssuingOrg": {
                return Optional.ofNullable(clazz.cast(this.identificationIssuingOrg()));
            }
            case "DevicePickupId": {
                return Optional.ofNullable(clazz.cast(this.devicePickupId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("PhoneNumber", PHONE_NUMBER_FIELD);
        map.put("Email", EMAIL_FIELD);
        map.put("IdentificationNumber", IDENTIFICATION_NUMBER_FIELD);
        map.put("IdentificationExpirationDate", IDENTIFICATION_EXPIRATION_DATE_FIELD);
        map.put("IdentificationIssuingOrg", IDENTIFICATION_ISSUING_ORG_FIELD);
        map.put("DevicePickupId", DEVICE_PICKUP_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PickupDetails, T> g) {
        return obj -> g.apply((PickupDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String phoneNumber;
        private String email;
        private String identificationNumber;
        private Instant identificationExpirationDate;
        private String identificationIssuingOrg;
        private String devicePickupId;

        private BuilderImpl() {
        }

        private BuilderImpl(PickupDetails model) {
            this.name(model.name);
            this.phoneNumber(model.phoneNumber);
            this.email(model.email);
            this.identificationNumber(model.identificationNumber);
            this.identificationExpirationDate(model.identificationExpirationDate);
            this.identificationIssuingOrg(model.identificationIssuingOrg);
            this.devicePickupId(model.devicePickupId);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPhoneNumber() {
            return this.phoneNumber;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final String getEmail() {
            return this.email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final String getIdentificationNumber() {
            return this.identificationNumber;
        }

        public final void setIdentificationNumber(String identificationNumber) {
            this.identificationNumber = identificationNumber;
        }

        @Override
        public final Builder identificationNumber(String identificationNumber) {
            this.identificationNumber = identificationNumber;
            return this;
        }

        public final Instant getIdentificationExpirationDate() {
            return this.identificationExpirationDate;
        }

        public final void setIdentificationExpirationDate(Instant identificationExpirationDate) {
            this.identificationExpirationDate = identificationExpirationDate;
        }

        @Override
        public final Builder identificationExpirationDate(Instant identificationExpirationDate) {
            this.identificationExpirationDate = identificationExpirationDate;
            return this;
        }

        public final String getIdentificationIssuingOrg() {
            return this.identificationIssuingOrg;
        }

        public final void setIdentificationIssuingOrg(String identificationIssuingOrg) {
            this.identificationIssuingOrg = identificationIssuingOrg;
        }

        @Override
        public final Builder identificationIssuingOrg(String identificationIssuingOrg) {
            this.identificationIssuingOrg = identificationIssuingOrg;
            return this;
        }

        public final String getDevicePickupId() {
            return this.devicePickupId;
        }

        public final void setDevicePickupId(String devicePickupId) {
            this.devicePickupId = devicePickupId;
        }

        @Override
        public final Builder devicePickupId(String devicePickupId) {
            this.devicePickupId = devicePickupId;
            return this;
        }

        public PickupDetails build() {
            return new PickupDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PickupDetails> {
        public Builder name(String var1);

        public Builder phoneNumber(String var1);

        public Builder email(String var1);

        public Builder identificationNumber(String var1);

        public Builder identificationExpirationDate(Instant var1);

        public Builder identificationIssuingOrg(String var1);

        public Builder devicePickupId(String var1);
    }
}

