/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReturnShippingLabelResponse extends SnowballResponse implements
        ToCopyableBuilder<DescribeReturnShippingLabelResponse.Builder, DescribeReturnShippingLabelResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeReturnShippingLabelResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> EXPIRATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpirationDate").getter(getter(DescribeReturnShippingLabelResponse::expirationDate))
            .setter(setter(Builder::expirationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationDate").build()).build();

    private static final SdkField<String> RETURN_SHIPPING_LABEL_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReturnShippingLabelURI").getter(getter(DescribeReturnShippingLabelResponse::returnShippingLabelURI))
            .setter(setter(Builder::returnShippingLabelURI))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnShippingLabelURI").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            EXPIRATION_DATE_FIELD, RETURN_SHIPPING_LABEL_URI_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String status;

    private final Instant expirationDate;

    private final String returnShippingLabelURI;

    private DescribeReturnShippingLabelResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.expirationDate = builder.expirationDate;
        this.returnShippingLabelURI = builder.returnShippingLabelURI;
    }

    /**
     * <p>
     * The status information of the task on a Snow device that is being returned to Amazon Web Services.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ShippingLabelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status information of the task on a Snow device that is being returned to Amazon Web Services.
     * @see ShippingLabelStatus
     */
    public final ShippingLabelStatus status() {
        return ShippingLabelStatus.fromValue(status);
    }

    /**
     * <p>
     * The status information of the task on a Snow device that is being returned to Amazon Web Services.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ShippingLabelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status information of the task on a Snow device that is being returned to Amazon Web Services.
     * @see ShippingLabelStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The expiration date of the current return shipping label.
     * </p>
     * 
     * @return The expiration date of the current return shipping label.
     */
    public final Instant expirationDate() {
        return expirationDate;
    }

    /**
     * <p>
     * The pre-signed Amazon S3 URI used to download the return shipping label.
     * </p>
     * 
     * @return The pre-signed Amazon S3 URI used to download the return shipping label.
     */
    public final String returnShippingLabelURI() {
        return returnShippingLabelURI;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(returnShippingLabelURI());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReturnShippingLabelResponse)) {
            return false;
        }
        DescribeReturnShippingLabelResponse other = (DescribeReturnShippingLabelResponse) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(expirationDate(), other.expirationDate())
                && Objects.equals(returnShippingLabelURI(), other.returnShippingLabelURI());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeReturnShippingLabelResponse").add("Status", statusAsString())
                .add("ExpirationDate", expirationDate()).add("ReturnShippingLabelURI", returnShippingLabelURI()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ExpirationDate":
            return Optional.ofNullable(clazz.cast(expirationDate()));
        case "ReturnShippingLabelURI":
            return Optional.ofNullable(clazz.cast(returnShippingLabelURI()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        map.put("ExpirationDate", EXPIRATION_DATE_FIELD);
        map.put("ReturnShippingLabelURI", RETURN_SHIPPING_LABEL_URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeReturnShippingLabelResponse, T> g) {
        return obj -> g.apply((DescribeReturnShippingLabelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SnowballResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeReturnShippingLabelResponse> {
        /**
         * <p>
         * The status information of the task on a Snow device that is being returned to Amazon Web Services.
         * </p>
         * 
         * @param status
         *        The status information of the task on a Snow device that is being returned to Amazon Web Services.
         * @see ShippingLabelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShippingLabelStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status information of the task on a Snow device that is being returned to Amazon Web Services.
         * </p>
         * 
         * @param status
         *        The status information of the task on a Snow device that is being returned to Amazon Web Services.
         * @see ShippingLabelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShippingLabelStatus
         */
        Builder status(ShippingLabelStatus status);

        /**
         * <p>
         * The expiration date of the current return shipping label.
         * </p>
         * 
         * @param expirationDate
         *        The expiration date of the current return shipping label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationDate(Instant expirationDate);

        /**
         * <p>
         * The pre-signed Amazon S3 URI used to download the return shipping label.
         * </p>
         * 
         * @param returnShippingLabelURI
         *        The pre-signed Amazon S3 URI used to download the return shipping label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnShippingLabelURI(String returnShippingLabelURI);
    }

    static final class BuilderImpl extends SnowballResponse.BuilderImpl implements Builder {
        private String status;

        private Instant expirationDate;

        private String returnShippingLabelURI;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReturnShippingLabelResponse model) {
            super(model);
            status(model.status);
            expirationDate(model.expirationDate);
            returnShippingLabelURI(model.returnShippingLabelURI);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ShippingLabelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getExpirationDate() {
            return expirationDate;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final String getReturnShippingLabelURI() {
            return returnShippingLabelURI;
        }

        public final void setReturnShippingLabelURI(String returnShippingLabelURI) {
            this.returnShippingLabelURI = returnShippingLabelURI;
        }

        @Override
        public final Builder returnShippingLabelURI(String returnShippingLabelURI) {
            this.returnShippingLabelURI = returnShippingLabelURI;
            return this;
        }

        @Override
        public DescribeReturnShippingLabelResponse build() {
            return new DescribeReturnShippingLabelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
