/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCompatibleImagesResponse extends SnowballResponse implements
        ToCopyableBuilder<ListCompatibleImagesResponse.Builder, ListCompatibleImagesResponse> {
    private static final SdkField<List<CompatibleImage>> COMPATIBLE_IMAGES_FIELD = SdkField
            .<List<CompatibleImage>> builder(MarshallingType.LIST)
            .getter(getter(ListCompatibleImagesResponse::compatibleImages))
            .setter(setter(Builder::compatibleImages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompatibleImages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CompatibleImage> builder(MarshallingType.SDK_POJO)
                                            .constructor(CompatibleImage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListCompatibleImagesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPATIBLE_IMAGES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<CompatibleImage> compatibleImages;

    private final String nextToken;

    private ListCompatibleImagesResponse(BuilderImpl builder) {
        super(builder);
        this.compatibleImages = builder.compatibleImages;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A JSON-formatted object that describes a compatible AMI.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A JSON-formatted object that describes a compatible AMI.
     */
    public List<CompatibleImage> compatibleImages() {
        return compatibleImages;
    }

    /**
     * <p>
     * Because HTTP requests are stateless, this is the starting point for your next list of returned images.
     * </p>
     * 
     * @return Because HTTP requests are stateless, this is the starting point for your next list of returned images.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(compatibleImages());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCompatibleImagesResponse)) {
            return false;
        }
        ListCompatibleImagesResponse other = (ListCompatibleImagesResponse) obj;
        return Objects.equals(compatibleImages(), other.compatibleImages()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListCompatibleImagesResponse").add("CompatibleImages", compatibleImages())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CompatibleImages":
            return Optional.ofNullable(clazz.cast(compatibleImages()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCompatibleImagesResponse, T> g) {
        return obj -> g.apply((ListCompatibleImagesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnowballResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListCompatibleImagesResponse> {
        /**
         * <p>
         * A JSON-formatted object that describes a compatible AMI.
         * </p>
         * 
         * @param compatibleImages
         *        A JSON-formatted object that describes a compatible AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleImages(Collection<CompatibleImage> compatibleImages);

        /**
         * <p>
         * A JSON-formatted object that describes a compatible AMI.
         * </p>
         * 
         * @param compatibleImages
         *        A JSON-formatted object that describes a compatible AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleImages(CompatibleImage... compatibleImages);

        /**
         * <p>
         * A JSON-formatted object that describes a compatible AMI.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CompatibleImage>.Builder} avoiding the need
         * to create one manually via {@link List<CompatibleImage>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CompatibleImage>.Builder#build()} is called immediately and
         * its result is passed to {@link #compatibleImages(List<CompatibleImage>)}.
         * 
         * @param compatibleImages
         *        a consumer that will call methods on {@link List<CompatibleImage>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compatibleImages(List<CompatibleImage>)
         */
        Builder compatibleImages(Consumer<CompatibleImage.Builder>... compatibleImages);

        /**
         * <p>
         * Because HTTP requests are stateless, this is the starting point for your next list of returned images.
         * </p>
         * 
         * @param nextToken
         *        Because HTTP requests are stateless, this is the starting point for your next list of returned images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SnowballResponse.BuilderImpl implements Builder {
        private List<CompatibleImage> compatibleImages = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCompatibleImagesResponse model) {
            super(model);
            compatibleImages(model.compatibleImages);
            nextToken(model.nextToken);
        }

        public final Collection<CompatibleImage.Builder> getCompatibleImages() {
            return compatibleImages != null ? compatibleImages.stream().map(CompatibleImage::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder compatibleImages(Collection<CompatibleImage> compatibleImages) {
            this.compatibleImages = CompatibleImageListCopier.copy(compatibleImages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleImages(CompatibleImage... compatibleImages) {
            compatibleImages(Arrays.asList(compatibleImages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleImages(Consumer<CompatibleImage.Builder>... compatibleImages) {
            compatibleImages(Stream.of(compatibleImages).map(c -> CompatibleImage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCompatibleImages(Collection<CompatibleImage.BuilderImpl> compatibleImages) {
            this.compatibleImages = CompatibleImageListCopier.copyFromBuilder(compatibleImages);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListCompatibleImagesResponse build() {
            return new ListCompatibleImagesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
