/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON-formatted object that contains the IDs for an Amazon Machine Image (AMI), including the Amazon EC2 AMI ID and
 * the Snowball Edge AMI ID. Each AMI has these two IDs to simplify identifying the AMI in both the AWS Cloud and on the
 * device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Ec2AmiResource implements SdkPojo, Serializable, ToCopyableBuilder<Ec2AmiResource.Builder, Ec2AmiResource> {
    private static final SdkField<String> AMI_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Ec2AmiResource::amiId)).setter(setter(Builder::amiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmiId").build()).build();

    private static final SdkField<String> SNOWBALL_AMI_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Ec2AmiResource::snowballAmiId)).setter(setter(Builder::snowballAmiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnowballAmiId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMI_ID_FIELD,
            SNOWBALL_AMI_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String amiId;

    private final String snowballAmiId;

    private Ec2AmiResource(BuilderImpl builder) {
        this.amiId = builder.amiId;
        this.snowballAmiId = builder.snowballAmiId;
    }

    /**
     * <p>
     * The ID of the AMI in Amazon EC2.
     * </p>
     * 
     * @return The ID of the AMI in Amazon EC2.
     */
    public String amiId() {
        return amiId;
    }

    /**
     * <p>
     * The ID of the AMI on the supported device.
     * </p>
     * 
     * @return The ID of the AMI on the supported device.
     */
    public String snowballAmiId() {
        return snowballAmiId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amiId());
        hashCode = 31 * hashCode + Objects.hashCode(snowballAmiId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2AmiResource)) {
            return false;
        }
        Ec2AmiResource other = (Ec2AmiResource) obj;
        return Objects.equals(amiId(), other.amiId()) && Objects.equals(snowballAmiId(), other.snowballAmiId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Ec2AmiResource").add("AmiId", amiId()).add("SnowballAmiId", snowballAmiId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AmiId":
            return Optional.ofNullable(clazz.cast(amiId()));
        case "SnowballAmiId":
            return Optional.ofNullable(clazz.cast(snowballAmiId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Ec2AmiResource, T> g) {
        return obj -> g.apply((Ec2AmiResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Ec2AmiResource> {
        /**
         * <p>
         * The ID of the AMI in Amazon EC2.
         * </p>
         * 
         * @param amiId
         *        The ID of the AMI in Amazon EC2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amiId(String amiId);

        /**
         * <p>
         * The ID of the AMI on the supported device.
         * </p>
         * 
         * @param snowballAmiId
         *        The ID of the AMI on the supported device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snowballAmiId(String snowballAmiId);
    }

    static final class BuilderImpl implements Builder {
        private String amiId;

        private String snowballAmiId;

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2AmiResource model) {
            amiId(model.amiId);
            snowballAmiId(model.snowballAmiId);
        }

        public final String getAmiId() {
            return amiId;
        }

        @Override
        public final Builder amiId(String amiId) {
            this.amiId = amiId;
            return this;
        }

        public final void setAmiId(String amiId) {
            this.amiId = amiId;
        }

        public final String getSnowballAmiId() {
            return snowballAmiId;
        }

        @Override
        public final Builder snowballAmiId(String snowballAmiId) {
            this.snowballAmiId = snowballAmiId;
            return this;
        }

        public final void setSnowballAmiId(String snowballAmiId) {
            this.snowballAmiId = snowballAmiId;
        }

        @Override
        public Ec2AmiResource build() {
            return new Ec2AmiResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
