/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowdevicemanagement.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.snowdevicemanagement.model.Capacity;
import software.amazon.awssdk.services.snowdevicemanagement.model.CapacityListCopier;
import software.amazon.awssdk.services.snowdevicemanagement.model.PhysicalNetworkInterface;
import software.amazon.awssdk.services.snowdevicemanagement.model.PhysicalNetworkInterfaceListCopier;
import software.amazon.awssdk.services.snowdevicemanagement.model.SnowDeviceManagementResponse;
import software.amazon.awssdk.services.snowdevicemanagement.model.SoftwareInformation;
import software.amazon.awssdk.services.snowdevicemanagement.model.TagMapCopier;
import software.amazon.awssdk.services.snowdevicemanagement.model.UnlockState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDeviceResponse
extends SnowDeviceManagementResponse
implements ToCopyableBuilder<Builder, DescribeDeviceResponse> {
    private static final SdkField<String> ASSOCIATED_WITH_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("associatedWithJob").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::associatedWithJob)).setter(DescribeDeviceResponse.setter(Builder::associatedWithJob)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedWithJob").build()}).build();
    private static final SdkField<List<Capacity>> DEVICE_CAPACITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("deviceCapacities").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::deviceCapacities)).setter(DescribeDeviceResponse.setter(Builder::deviceCapacities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceCapacities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Capacity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DEVICE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deviceState").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::deviceStateAsString)).setter(DescribeDeviceResponse.setter(Builder::deviceState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceState").build()}).build();
    private static final SdkField<String> DEVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deviceType").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::deviceType)).setter(DescribeDeviceResponse.setter(Builder::deviceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceType").build()}).build();
    private static final SdkField<Instant> LAST_REACHED_OUT_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastReachedOutAt").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::lastReachedOutAt)).setter(DescribeDeviceResponse.setter(Builder::lastReachedOutAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastReachedOutAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::lastUpdatedAt)).setter(DescribeDeviceResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final SdkField<String> MANAGED_DEVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("managedDeviceArn").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::managedDeviceArn)).setter(DescribeDeviceResponse.setter(Builder::managedDeviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedDeviceArn").build()}).build();
    private static final SdkField<String> MANAGED_DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("managedDeviceId").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::managedDeviceId)).setter(DescribeDeviceResponse.setter(Builder::managedDeviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedDeviceId").build()}).build();
    private static final SdkField<List<PhysicalNetworkInterface>> PHYSICAL_NETWORK_INTERFACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("physicalNetworkInterfaces").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::physicalNetworkInterfaces)).setter(DescribeDeviceResponse.setter(Builder::physicalNetworkInterfaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("physicalNetworkInterfaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PhysicalNetworkInterface::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SoftwareInformation> SOFTWARE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("software").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::software)).setter(DescribeDeviceResponse.setter(Builder::software)).constructor(SoftwareInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("software").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::tags)).setter(DescribeDeviceResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATED_WITH_JOB_FIELD, DEVICE_CAPACITIES_FIELD, DEVICE_STATE_FIELD, DEVICE_TYPE_FIELD, LAST_REACHED_OUT_AT_FIELD, LAST_UPDATED_AT_FIELD, MANAGED_DEVICE_ARN_FIELD, MANAGED_DEVICE_ID_FIELD, PHYSICAL_NETWORK_INTERFACES_FIELD, SOFTWARE_FIELD, TAGS_FIELD));
    private final String associatedWithJob;
    private final List<Capacity> deviceCapacities;
    private final String deviceState;
    private final String deviceType;
    private final Instant lastReachedOutAt;
    private final Instant lastUpdatedAt;
    private final String managedDeviceArn;
    private final String managedDeviceId;
    private final List<PhysicalNetworkInterface> physicalNetworkInterfaces;
    private final SoftwareInformation software;
    private final Map<String, String> tags;

    private DescribeDeviceResponse(BuilderImpl builder) {
        super(builder);
        this.associatedWithJob = builder.associatedWithJob;
        this.deviceCapacities = builder.deviceCapacities;
        this.deviceState = builder.deviceState;
        this.deviceType = builder.deviceType;
        this.lastReachedOutAt = builder.lastReachedOutAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.managedDeviceArn = builder.managedDeviceArn;
        this.managedDeviceId = builder.managedDeviceId;
        this.physicalNetworkInterfaces = builder.physicalNetworkInterfaces;
        this.software = builder.software;
        this.tags = builder.tags;
    }

    public final String associatedWithJob() {
        return this.associatedWithJob;
    }

    public final boolean hasDeviceCapacities() {
        return this.deviceCapacities != null && !(this.deviceCapacities instanceof SdkAutoConstructList);
    }

    public final List<Capacity> deviceCapacities() {
        return this.deviceCapacities;
    }

    public final UnlockState deviceState() {
        return UnlockState.fromValue(this.deviceState);
    }

    public final String deviceStateAsString() {
        return this.deviceState;
    }

    public final String deviceType() {
        return this.deviceType;
    }

    public final Instant lastReachedOutAt() {
        return this.lastReachedOutAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final String managedDeviceArn() {
        return this.managedDeviceArn;
    }

    public final String managedDeviceId() {
        return this.managedDeviceId;
    }

    public final boolean hasPhysicalNetworkInterfaces() {
        return this.physicalNetworkInterfaces != null && !(this.physicalNetworkInterfaces instanceof SdkAutoConstructList);
    }

    public final List<PhysicalNetworkInterface> physicalNetworkInterfaces() {
        return this.physicalNetworkInterfaces;
    }

    public final SoftwareInformation software() {
        return this.software;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedWithJob());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeviceCapacities() ? this.deviceCapacities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastReachedOutAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedDeviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedDeviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhysicalNetworkInterfaces() ? this.physicalNetworkInterfaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.software());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeviceResponse)) {
            return false;
        }
        DescribeDeviceResponse other = (DescribeDeviceResponse)((Object)obj);
        return Objects.equals(this.associatedWithJob(), other.associatedWithJob()) && this.hasDeviceCapacities() == other.hasDeviceCapacities() && Objects.equals(this.deviceCapacities(), other.deviceCapacities()) && Objects.equals(this.deviceStateAsString(), other.deviceStateAsString()) && Objects.equals(this.deviceType(), other.deviceType()) && Objects.equals(this.lastReachedOutAt(), other.lastReachedOutAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.managedDeviceArn(), other.managedDeviceArn()) && Objects.equals(this.managedDeviceId(), other.managedDeviceId()) && this.hasPhysicalNetworkInterfaces() == other.hasPhysicalNetworkInterfaces() && Objects.equals(this.physicalNetworkInterfaces(), other.physicalNetworkInterfaces()) && Objects.equals(this.software(), other.software()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDeviceResponse").add("AssociatedWithJob", (Object)this.associatedWithJob()).add("DeviceCapacities", this.hasDeviceCapacities() ? this.deviceCapacities() : null).add("DeviceState", (Object)this.deviceStateAsString()).add("DeviceType", (Object)this.deviceType()).add("LastReachedOutAt", (Object)this.lastReachedOutAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("ManagedDeviceArn", (Object)this.managedDeviceArn()).add("ManagedDeviceId", (Object)this.managedDeviceId()).add("PhysicalNetworkInterfaces", this.hasPhysicalNetworkInterfaces() ? this.physicalNetworkInterfaces() : null).add("Software", (Object)this.software()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "associatedWithJob": {
                return Optional.ofNullable(clazz.cast(this.associatedWithJob()));
            }
            case "deviceCapacities": {
                return Optional.ofNullable(clazz.cast(this.deviceCapacities()));
            }
            case "deviceState": {
                return Optional.ofNullable(clazz.cast(this.deviceStateAsString()));
            }
            case "deviceType": {
                return Optional.ofNullable(clazz.cast(this.deviceType()));
            }
            case "lastReachedOutAt": {
                return Optional.ofNullable(clazz.cast(this.lastReachedOutAt()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "managedDeviceArn": {
                return Optional.ofNullable(clazz.cast(this.managedDeviceArn()));
            }
            case "managedDeviceId": {
                return Optional.ofNullable(clazz.cast(this.managedDeviceId()));
            }
            case "physicalNetworkInterfaces": {
                return Optional.ofNullable(clazz.cast(this.physicalNetworkInterfaces()));
            }
            case "software": {
                return Optional.ofNullable(clazz.cast(this.software()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDeviceResponse, T> g) {
        return obj -> g.apply((DescribeDeviceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SnowDeviceManagementResponse.BuilderImpl
    implements Builder {
        private String associatedWithJob;
        private List<Capacity> deviceCapacities = DefaultSdkAutoConstructList.getInstance();
        private String deviceState;
        private String deviceType;
        private Instant lastReachedOutAt;
        private Instant lastUpdatedAt;
        private String managedDeviceArn;
        private String managedDeviceId;
        private List<PhysicalNetworkInterface> physicalNetworkInterfaces = DefaultSdkAutoConstructList.getInstance();
        private SoftwareInformation software;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeviceResponse model) {
            super(model);
            this.associatedWithJob(model.associatedWithJob);
            this.deviceCapacities(model.deviceCapacities);
            this.deviceState(model.deviceState);
            this.deviceType(model.deviceType);
            this.lastReachedOutAt(model.lastReachedOutAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.managedDeviceArn(model.managedDeviceArn);
            this.managedDeviceId(model.managedDeviceId);
            this.physicalNetworkInterfaces(model.physicalNetworkInterfaces);
            this.software(model.software);
            this.tags(model.tags);
        }

        public final String getAssociatedWithJob() {
            return this.associatedWithJob;
        }

        public final void setAssociatedWithJob(String associatedWithJob) {
            this.associatedWithJob = associatedWithJob;
        }

        @Override
        @Transient
        public final Builder associatedWithJob(String associatedWithJob) {
            this.associatedWithJob = associatedWithJob;
            return this;
        }

        public final List<Capacity.Builder> getDeviceCapacities() {
            List<Capacity.Builder> result = CapacityListCopier.copyToBuilder(this.deviceCapacities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeviceCapacities(Collection<Capacity.BuilderImpl> deviceCapacities) {
            this.deviceCapacities = CapacityListCopier.copyFromBuilder(deviceCapacities);
        }

        @Override
        @Transient
        public final Builder deviceCapacities(Collection<Capacity> deviceCapacities) {
            this.deviceCapacities = CapacityListCopier.copy(deviceCapacities);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder deviceCapacities(Capacity ... deviceCapacities) {
            this.deviceCapacities(Arrays.asList(deviceCapacities));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder deviceCapacities(Consumer<Capacity.Builder> ... deviceCapacities) {
            this.deviceCapacities(Stream.of(deviceCapacities).map(c -> (Capacity)((Capacity.Builder)Capacity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDeviceState() {
            return this.deviceState;
        }

        public final void setDeviceState(String deviceState) {
            this.deviceState = deviceState;
        }

        @Override
        @Transient
        public final Builder deviceState(String deviceState) {
            this.deviceState = deviceState;
            return this;
        }

        @Override
        @Transient
        public final Builder deviceState(UnlockState deviceState) {
            this.deviceState(deviceState == null ? null : deviceState.toString());
            return this;
        }

        public final String getDeviceType() {
            return this.deviceType;
        }

        public final void setDeviceType(String deviceType) {
            this.deviceType = deviceType;
        }

        @Override
        @Transient
        public final Builder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public final Instant getLastReachedOutAt() {
            return this.lastReachedOutAt;
        }

        public final void setLastReachedOutAt(Instant lastReachedOutAt) {
            this.lastReachedOutAt = lastReachedOutAt;
        }

        @Override
        @Transient
        public final Builder lastReachedOutAt(Instant lastReachedOutAt) {
            this.lastReachedOutAt = lastReachedOutAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        @Transient
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getManagedDeviceArn() {
            return this.managedDeviceArn;
        }

        public final void setManagedDeviceArn(String managedDeviceArn) {
            this.managedDeviceArn = managedDeviceArn;
        }

        @Override
        @Transient
        public final Builder managedDeviceArn(String managedDeviceArn) {
            this.managedDeviceArn = managedDeviceArn;
            return this;
        }

        public final String getManagedDeviceId() {
            return this.managedDeviceId;
        }

        public final void setManagedDeviceId(String managedDeviceId) {
            this.managedDeviceId = managedDeviceId;
        }

        @Override
        @Transient
        public final Builder managedDeviceId(String managedDeviceId) {
            this.managedDeviceId = managedDeviceId;
            return this;
        }

        public final List<PhysicalNetworkInterface.Builder> getPhysicalNetworkInterfaces() {
            List<PhysicalNetworkInterface.Builder> result = PhysicalNetworkInterfaceListCopier.copyToBuilder(this.physicalNetworkInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhysicalNetworkInterfaces(Collection<PhysicalNetworkInterface.BuilderImpl> physicalNetworkInterfaces) {
            this.physicalNetworkInterfaces = PhysicalNetworkInterfaceListCopier.copyFromBuilder(physicalNetworkInterfaces);
        }

        @Override
        @Transient
        public final Builder physicalNetworkInterfaces(Collection<PhysicalNetworkInterface> physicalNetworkInterfaces) {
            this.physicalNetworkInterfaces = PhysicalNetworkInterfaceListCopier.copy(physicalNetworkInterfaces);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder physicalNetworkInterfaces(PhysicalNetworkInterface ... physicalNetworkInterfaces) {
            this.physicalNetworkInterfaces(Arrays.asList(physicalNetworkInterfaces));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder physicalNetworkInterfaces(Consumer<PhysicalNetworkInterface.Builder> ... physicalNetworkInterfaces) {
            this.physicalNetworkInterfaces(Stream.of(physicalNetworkInterfaces).map(c -> (PhysicalNetworkInterface)((PhysicalNetworkInterface.Builder)PhysicalNetworkInterface.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final SoftwareInformation.Builder getSoftware() {
            return this.software != null ? this.software.toBuilder() : null;
        }

        public final void setSoftware(SoftwareInformation.BuilderImpl software) {
            this.software = software != null ? software.build() : null;
        }

        @Override
        @Transient
        public final Builder software(SoftwareInformation software) {
            this.software = software;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public DescribeDeviceResponse build() {
            return new DescribeDeviceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SnowDeviceManagementResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDeviceResponse> {
        public Builder associatedWithJob(String var1);

        public Builder deviceCapacities(Collection<Capacity> var1);

        public Builder deviceCapacities(Capacity ... var1);

        public Builder deviceCapacities(Consumer<Capacity.Builder> ... var1);

        public Builder deviceState(String var1);

        public Builder deviceState(UnlockState var1);

        public Builder deviceType(String var1);

        public Builder lastReachedOutAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder managedDeviceArn(String var1);

        public Builder managedDeviceId(String var1);

        public Builder physicalNetworkInterfaces(Collection<PhysicalNetworkInterface> var1);

        public Builder physicalNetworkInterfaces(PhysicalNetworkInterface ... var1);

        public Builder physicalNetworkInterfaces(Consumer<PhysicalNetworkInterface.Builder> ... var1);

        public Builder software(SoftwareInformation var1);

        default public Builder software(Consumer<SoftwareInformation.Builder> software) {
            return this.software((SoftwareInformation)((SoftwareInformation.Builder)SoftwareInformation.builder().applyMutation(software)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

