/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowdevicemanagement.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.snowdevicemanagement.model.ResourceSummary;
import software.amazon.awssdk.services.snowdevicemanagement.model.ResourceSummaryListCopier;
import software.amazon.awssdk.services.snowdevicemanagement.model.SnowDeviceManagementResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDeviceResourcesResponse
extends SnowDeviceManagementResponse
implements ToCopyableBuilder<Builder, ListDeviceResourcesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDeviceResourcesResponse.getter(ListDeviceResourcesResponse::nextToken)).setter(ListDeviceResourcesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ResourceSummary>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resources").getter(ListDeviceResourcesResponse.getter(ListDeviceResourcesResponse::resources)).setter(ListDeviceResourcesResponse.setter(Builder::resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RESOURCES_FIELD));
    private final String nextToken;
    private final List<ResourceSummary> resources;

    private ListDeviceResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.resources = builder.resources;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasResources() {
        return this.resources != null && !(this.resources instanceof SdkAutoConstructList);
    }

    public final List<ResourceSummary> resources() {
        return this.resources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResources() ? this.resources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeviceResourcesResponse)) {
            return false;
        }
        ListDeviceResourcesResponse other = (ListDeviceResourcesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasResources() == other.hasResources() && Objects.equals(this.resources(), other.resources());
    }

    public final String toString() {
        return ToString.builder((String)"ListDeviceResourcesResponse").add("NextToken", (Object)this.nextToken()).add("Resources", this.hasResources() ? this.resources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDeviceResourcesResponse, T> g) {
        return obj -> g.apply((ListDeviceResourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SnowDeviceManagementResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ResourceSummary> resources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeviceResourcesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.resources(model.resources);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ResourceSummary.Builder> getResources() {
            List<ResourceSummary.Builder> result = ResourceSummaryListCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<ResourceSummary.BuilderImpl> resources) {
            this.resources = ResourceSummaryListCopier.copyFromBuilder(resources);
        }

        @Override
        @Transient
        public final Builder resources(Collection<ResourceSummary> resources) {
            this.resources = ResourceSummaryListCopier.copy(resources);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resources(ResourceSummary ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resources(Consumer<ResourceSummary.Builder> ... resources) {
            this.resources(Stream.of(resources).map(c -> (ResourceSummary)((ResourceSummary.Builder)ResourceSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListDeviceResourcesResponse build() {
            return new ListDeviceResourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SnowDeviceManagementResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDeviceResourcesResponse> {
        public Builder nextToken(String var1);

        public Builder resources(Collection<ResourceSummary> var1);

        public Builder resources(ResourceSummary ... var1);

        public Builder resources(Consumer<ResourceSummary.Builder> ... var1);
    }
}

