/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowdevicemanagement.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ExecutionState {
    QUEUED("QUEUED"),
    IN_PROGRESS("IN_PROGRESS"),
    CANCELED("CANCELED"),
    FAILED("FAILED"),
    SUCCEEDED("SUCCEEDED"),
    REJECTED("REJECTED"),
    TIMED_OUT("TIMED_OUT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ExecutionState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExecutionState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ExecutionState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExecutionState> knownValues() {
        return Stream.of(ExecutionState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

