/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowdevicemanagement.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.snowdevicemanagement.model.ExecutionState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecutionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExecutionSummary> {
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionId").getter(ExecutionSummary.getter(ExecutionSummary::executionId)).setter(ExecutionSummary.setter(Builder::executionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionId").build()}).build();
    private static final SdkField<String> MANAGED_DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("managedDeviceId").getter(ExecutionSummary.getter(ExecutionSummary::managedDeviceId)).setter(ExecutionSummary.setter(Builder::managedDeviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedDeviceId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(ExecutionSummary.getter(ExecutionSummary::stateAsString)).setter(ExecutionSummary.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskId").getter(ExecutionSummary.getter(ExecutionSummary::taskId)).setter(ExecutionSummary.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ID_FIELD, MANAGED_DEVICE_ID_FIELD, STATE_FIELD, TASK_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String executionId;
    private final String managedDeviceId;
    private final String state;
    private final String taskId;

    private ExecutionSummary(BuilderImpl builder) {
        this.executionId = builder.executionId;
        this.managedDeviceId = builder.managedDeviceId;
        this.state = builder.state;
        this.taskId = builder.taskId;
    }

    public final String executionId() {
        return this.executionId;
    }

    public final String managedDeviceId() {
        return this.managedDeviceId;
    }

    public final ExecutionState state() {
        return ExecutionState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String taskId() {
        return this.taskId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.executionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedDeviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionSummary)) {
            return false;
        }
        ExecutionSummary other = (ExecutionSummary)obj;
        return Objects.equals(this.executionId(), other.executionId()) && Objects.equals(this.managedDeviceId(), other.managedDeviceId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.taskId(), other.taskId());
    }

    public final String toString() {
        return ToString.builder((String)"ExecutionSummary").add("ExecutionId", (Object)this.executionId()).add("ManagedDeviceId", (Object)this.managedDeviceId()).add("State", (Object)this.stateAsString()).add("TaskId", (Object)this.taskId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "executionId": {
                return Optional.ofNullable(clazz.cast(this.executionId()));
            }
            case "managedDeviceId": {
                return Optional.ofNullable(clazz.cast(this.managedDeviceId()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "taskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecutionSummary, T> g) {
        return obj -> g.apply((ExecutionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String executionId;
        private String managedDeviceId;
        private String state;
        private String taskId;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionSummary model) {
            this.executionId(model.executionId);
            this.managedDeviceId(model.managedDeviceId);
            this.state(model.state);
            this.taskId(model.taskId);
        }

        public final String getExecutionId() {
            return this.executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        @Transient
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final String getManagedDeviceId() {
            return this.managedDeviceId;
        }

        public final void setManagedDeviceId(String managedDeviceId) {
            this.managedDeviceId = managedDeviceId;
        }

        @Override
        @Transient
        public final Builder managedDeviceId(String managedDeviceId) {
            this.managedDeviceId = managedDeviceId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(ExecutionState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getTaskId() {
            return this.taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        @Transient
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public ExecutionSummary build() {
            return new ExecutionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExecutionSummary> {
        public Builder executionId(String var1);

        public Builder managedDeviceId(String var1);

        public Builder state(String var1);

        public Builder state(ExecutionState var1);

        public Builder taskId(String var1);
    }
}

