/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowdevicemanagement.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum InstanceStateName {
    PENDING("PENDING"),
    RUNNING("RUNNING"),
    SHUTTING_DOWN("SHUTTING_DOWN"),
    TERMINATED("TERMINATED"),
    STOPPING("STOPPING"),
    STOPPED("STOPPED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private InstanceStateName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InstanceStateName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(InstanceStateName.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InstanceStateName> knownValues() {
        return Stream.of(InstanceStateName.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

