/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowdevicemanagement.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.snowdevicemanagement.model.Instance;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceSummary> {
    private static final SdkField<Instance> INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("instance").getter(InstanceSummary.getter(InstanceSummary::instance)).setter(InstanceSummary.setter(Builder::instance)).constructor(Instance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instance").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(InstanceSummary.getter(InstanceSummary::lastUpdatedAt)).setter(InstanceSummary.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_FIELD, LAST_UPDATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instance instance;
    private final Instant lastUpdatedAt;

    private InstanceSummary(BuilderImpl builder) {
        this.instance = builder.instance;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    public final Instance instance() {
        return this.instance;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instance());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceSummary)) {
            return false;
        }
        InstanceSummary other = (InstanceSummary)obj;
        return Objects.equals(this.instance(), other.instance()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceSummary").add("Instance", (Object)this.instance()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instance": {
                return Optional.ofNullable(clazz.cast(this.instance()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceSummary, T> g) {
        return obj -> g.apply((InstanceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instance instance;
        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceSummary model) {
            this.instance(model.instance);
            this.lastUpdatedAt(model.lastUpdatedAt);
        }

        public final Instance.Builder getInstance() {
            return this.instance != null ? this.instance.toBuilder() : null;
        }

        public final void setInstance(Instance.BuilderImpl instance) {
            this.instance = instance != null ? instance.build() : null;
        }

        @Override
        @Transient
        public final Builder instance(Instance instance) {
            this.instance = instance;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        @Transient
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public InstanceSummary build() {
            return new InstanceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceSummary> {
        public Builder instance(Instance var1);

        default public Builder instance(Consumer<Instance.Builder> instance) {
            return this.instance((Instance)((Instance.Builder)Instance.builder().applyMutation(instance)).build());
        }

        public Builder lastUpdatedAt(Instant var1);
    }
}

