/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowdevicemanagement.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The command given to the device to execute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Command implements SdkPojo, Serializable, ToCopyableBuilder<Command.Builder, Command> {
    private static final SdkField<Reboot> REBOOT_FIELD = SdkField.<Reboot> builder(MarshallingType.SDK_POJO).memberName("reboot")
            .getter(getter(Command::reboot)).setter(setter(Builder::reboot)).constructor(Reboot::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reboot").build()).build();

    private static final SdkField<Unlock> UNLOCK_FIELD = SdkField.<Unlock> builder(MarshallingType.SDK_POJO).memberName("unlock")
            .getter(getter(Command::unlock)).setter(setter(Builder::unlock)).constructor(Unlock::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unlock").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REBOOT_FIELD, UNLOCK_FIELD));

    private static final long serialVersionUID = 1L;

    private final Reboot reboot;

    private final Unlock unlock;

    private Command(BuilderImpl builder) {
        this.reboot = builder.reboot;
        this.unlock = builder.unlock;
    }

    /**
     * <p>
     * Reboots the device.
     * </p>
     * 
     * @return Reboots the device.
     */
    public final Reboot reboot() {
        return reboot;
    }

    /**
     * <p>
     * Unlocks the device.
     * </p>
     * 
     * @return Unlocks the device.
     */
    public final Unlock unlock() {
        return unlock;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reboot());
        hashCode = 31 * hashCode + Objects.hashCode(unlock());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Command)) {
            return false;
        }
        Command other = (Command) obj;
        return Objects.equals(reboot(), other.reboot()) && Objects.equals(unlock(), other.unlock());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Command").add("Reboot", reboot()).add("Unlock", unlock()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "reboot":
            return Optional.ofNullable(clazz.cast(reboot()));
        case "unlock":
            return Optional.ofNullable(clazz.cast(unlock()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Command, T> g) {
        return obj -> g.apply((Command) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Command> {
        /**
         * <p>
         * Reboots the device.
         * </p>
         * 
         * @param reboot
         *        Reboots the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reboot(Reboot reboot);

        /**
         * <p>
         * Reboots the device.
         * </p>
         * This is a convenience that creates an instance of the {@link Reboot.Builder} avoiding the need to create one
         * manually via {@link Reboot#builder()}.
         *
         * When the {@link Consumer} completes, {@link Reboot.Builder#build()} is called immediately and its result is
         * passed to {@link #reboot(Reboot)}.
         * 
         * @param reboot
         *        a consumer that will call methods on {@link Reboot.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reboot(Reboot)
         */
        default Builder reboot(Consumer<Reboot.Builder> reboot) {
            return reboot(Reboot.builder().applyMutation(reboot).build());
        }

        /**
         * <p>
         * Unlocks the device.
         * </p>
         * 
         * @param unlock
         *        Unlocks the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unlock(Unlock unlock);

        /**
         * <p>
         * Unlocks the device.
         * </p>
         * This is a convenience that creates an instance of the {@link Unlock.Builder} avoiding the need to create one
         * manually via {@link Unlock#builder()}.
         *
         * When the {@link Consumer} completes, {@link Unlock.Builder#build()} is called immediately and its result is
         * passed to {@link #unlock(Unlock)}.
         * 
         * @param unlock
         *        a consumer that will call methods on {@link Unlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unlock(Unlock)
         */
        default Builder unlock(Consumer<Unlock.Builder> unlock) {
            return unlock(Unlock.builder().applyMutation(unlock).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Reboot reboot;

        private Unlock unlock;

        private BuilderImpl() {
        }

        private BuilderImpl(Command model) {
            reboot(model.reboot);
            unlock(model.unlock);
        }

        public final Reboot.Builder getReboot() {
            return reboot != null ? reboot.toBuilder() : null;
        }

        public final void setReboot(Reboot.BuilderImpl reboot) {
            this.reboot = reboot != null ? reboot.build() : null;
        }

        @Override
        @Transient
        public final Builder reboot(Reboot reboot) {
            this.reboot = reboot;
            return this;
        }

        public final Unlock.Builder getUnlock() {
            return unlock != null ? unlock.toBuilder() : null;
        }

        public final void setUnlock(Unlock.BuilderImpl unlock) {
            this.unlock = unlock != null ? unlock.build() : null;
        }

        @Override
        @Transient
        public final Builder unlock(Unlock unlock) {
            this.unlock = unlock;
            return this;
        }

        @Override
        public Command build() {
            return new Command(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
