/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowdevicemanagement.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDeviceResponse extends SnowDeviceManagementResponse implements
        ToCopyableBuilder<DescribeDeviceResponse.Builder, DescribeDeviceResponse> {
    private static final SdkField<String> ASSOCIATED_WITH_JOB_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("associatedWithJob").getter(getter(DescribeDeviceResponse::associatedWithJob))
            .setter(setter(Builder::associatedWithJob))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedWithJob").build()).build();

    private static final SdkField<List<Capacity>> DEVICE_CAPACITIES_FIELD = SdkField
            .<List<Capacity>> builder(MarshallingType.LIST)
            .memberName("deviceCapacities")
            .getter(getter(DescribeDeviceResponse::deviceCapacities))
            .setter(setter(Builder::deviceCapacities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceCapacities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Capacity> builder(MarshallingType.SDK_POJO)
                                            .constructor(Capacity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DEVICE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deviceState").getter(getter(DescribeDeviceResponse::deviceStateAsString))
            .setter(setter(Builder::deviceState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceState").build()).build();

    private static final SdkField<String> DEVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deviceType").getter(getter(DescribeDeviceResponse::deviceType)).setter(setter(Builder::deviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceType").build()).build();

    private static final SdkField<Instant> LAST_REACHED_OUT_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastReachedOutAt").getter(getter(DescribeDeviceResponse::lastReachedOutAt))
            .setter(setter(Builder::lastReachedOutAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastReachedOutAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt").getter(getter(DescribeDeviceResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final SdkField<String> MANAGED_DEVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("managedDeviceArn").getter(getter(DescribeDeviceResponse::managedDeviceArn))
            .setter(setter(Builder::managedDeviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedDeviceArn").build()).build();

    private static final SdkField<String> MANAGED_DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("managedDeviceId").getter(getter(DescribeDeviceResponse::managedDeviceId))
            .setter(setter(Builder::managedDeviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedDeviceId").build()).build();

    private static final SdkField<List<PhysicalNetworkInterface>> PHYSICAL_NETWORK_INTERFACES_FIELD = SdkField
            .<List<PhysicalNetworkInterface>> builder(MarshallingType.LIST)
            .memberName("physicalNetworkInterfaces")
            .getter(getter(DescribeDeviceResponse::physicalNetworkInterfaces))
            .setter(setter(Builder::physicalNetworkInterfaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("physicalNetworkInterfaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PhysicalNetworkInterface> builder(MarshallingType.SDK_POJO)
                                            .constructor(PhysicalNetworkInterface::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SoftwareInformation> SOFTWARE_FIELD = SdkField
            .<SoftwareInformation> builder(MarshallingType.SDK_POJO).memberName("software")
            .getter(getter(DescribeDeviceResponse::software)).setter(setter(Builder::software))
            .constructor(SoftwareInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("software").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(DescribeDeviceResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATED_WITH_JOB_FIELD,
            DEVICE_CAPACITIES_FIELD, DEVICE_STATE_FIELD, DEVICE_TYPE_FIELD, LAST_REACHED_OUT_AT_FIELD, LAST_UPDATED_AT_FIELD,
            MANAGED_DEVICE_ARN_FIELD, MANAGED_DEVICE_ID_FIELD, PHYSICAL_NETWORK_INTERFACES_FIELD, SOFTWARE_FIELD, TAGS_FIELD));

    private final String associatedWithJob;

    private final List<Capacity> deviceCapacities;

    private final String deviceState;

    private final String deviceType;

    private final Instant lastReachedOutAt;

    private final Instant lastUpdatedAt;

    private final String managedDeviceArn;

    private final String managedDeviceId;

    private final List<PhysicalNetworkInterface> physicalNetworkInterfaces;

    private final SoftwareInformation software;

    private final Map<String, String> tags;

    private DescribeDeviceResponse(BuilderImpl builder) {
        super(builder);
        this.associatedWithJob = builder.associatedWithJob;
        this.deviceCapacities = builder.deviceCapacities;
        this.deviceState = builder.deviceState;
        this.deviceType = builder.deviceType;
        this.lastReachedOutAt = builder.lastReachedOutAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.managedDeviceArn = builder.managedDeviceArn;
        this.managedDeviceId = builder.managedDeviceId;
        this.physicalNetworkInterfaces = builder.physicalNetworkInterfaces;
        this.software = builder.software;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the job used when ordering the device.
     * </p>
     * 
     * @return The ID of the job used when ordering the device.
     */
    public final String associatedWithJob() {
        return associatedWithJob;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeviceCapacities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeviceCapacities() {
        return deviceCapacities != null && !(deviceCapacities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The hardware specifications of the device.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeviceCapacities} method.
     * </p>
     * 
     * @return The hardware specifications of the device.
     */
    public final List<Capacity> deviceCapacities() {
        return deviceCapacities;
    }

    /**
     * <p>
     * The current state of the device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceState} will
     * return {@link UnlockState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deviceStateAsString}.
     * </p>
     * 
     * @return The current state of the device.
     * @see UnlockState
     */
    public final UnlockState deviceState() {
        return UnlockState.fromValue(deviceState);
    }

    /**
     * <p>
     * The current state of the device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceState} will
     * return {@link UnlockState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deviceStateAsString}.
     * </p>
     * 
     * @return The current state of the device.
     * @see UnlockState
     */
    public final String deviceStateAsString() {
        return deviceState;
    }

    /**
     * <p>
     * The type of Amazon Web Services Snow Family device.
     * </p>
     * 
     * @return The type of Amazon Web Services Snow Family device.
     */
    public final String deviceType() {
        return deviceType;
    }

    /**
     * <p>
     * When the device last contacted the Amazon Web Services Cloud. Indicates that the device is online.
     * </p>
     * 
     * @return When the device last contacted the Amazon Web Services Cloud. Indicates that the device is online.
     */
    public final Instant lastReachedOutAt() {
        return lastReachedOutAt;
    }

    /**
     * <p>
     * When the device last pushed an update to the Amazon Web Services Cloud. Indicates when the device cache was
     * refreshed.
     * </p>
     * 
     * @return When the device last pushed an update to the Amazon Web Services Cloud. Indicates when the device cache
     *         was refreshed.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the device.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the device.
     */
    public final String managedDeviceArn() {
        return managedDeviceArn;
    }

    /**
     * <p>
     * The ID of the device that you checked the information for.
     * </p>
     * 
     * @return The ID of the device that you checked the information for.
     */
    public final String managedDeviceId() {
        return managedDeviceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the PhysicalNetworkInterfaces property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPhysicalNetworkInterfaces() {
        return physicalNetworkInterfaces != null && !(physicalNetworkInterfaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The network interfaces available on the device.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPhysicalNetworkInterfaces} method.
     * </p>
     * 
     * @return The network interfaces available on the device.
     */
    public final List<PhysicalNetworkInterface> physicalNetworkInterfaces() {
        return physicalNetworkInterfaces;
    }

    /**
     * <p>
     * The software installed on the device.
     * </p>
     * 
     * @return The software installed on the device.
     */
    public final SoftwareInformation software() {
        return software;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Optional metadata that you assign to a resource. You can use tags to categorize a resource in different ways,
     * such as by purpose, owner, or environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Optional metadata that you assign to a resource. You can use tags to categorize a resource in different
     *         ways, such as by purpose, owner, or environment.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(associatedWithJob());
        hashCode = 31 * hashCode + Objects.hashCode(hasDeviceCapacities() ? deviceCapacities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(deviceStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceType());
        hashCode = 31 * hashCode + Objects.hashCode(lastReachedOutAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(managedDeviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(managedDeviceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasPhysicalNetworkInterfaces() ? physicalNetworkInterfaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(software());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeviceResponse)) {
            return false;
        }
        DescribeDeviceResponse other = (DescribeDeviceResponse) obj;
        return Objects.equals(associatedWithJob(), other.associatedWithJob())
                && hasDeviceCapacities() == other.hasDeviceCapacities()
                && Objects.equals(deviceCapacities(), other.deviceCapacities())
                && Objects.equals(deviceStateAsString(), other.deviceStateAsString())
                && Objects.equals(deviceType(), other.deviceType())
                && Objects.equals(lastReachedOutAt(), other.lastReachedOutAt())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(managedDeviceArn(), other.managedDeviceArn())
                && Objects.equals(managedDeviceId(), other.managedDeviceId())
                && hasPhysicalNetworkInterfaces() == other.hasPhysicalNetworkInterfaces()
                && Objects.equals(physicalNetworkInterfaces(), other.physicalNetworkInterfaces())
                && Objects.equals(software(), other.software()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDeviceResponse").add("AssociatedWithJob", associatedWithJob())
                .add("DeviceCapacities", hasDeviceCapacities() ? deviceCapacities() : null)
                .add("DeviceState", deviceStateAsString()).add("DeviceType", deviceType())
                .add("LastReachedOutAt", lastReachedOutAt()).add("LastUpdatedAt", lastUpdatedAt())
                .add("ManagedDeviceArn", managedDeviceArn()).add("ManagedDeviceId", managedDeviceId())
                .add("PhysicalNetworkInterfaces", hasPhysicalNetworkInterfaces() ? physicalNetworkInterfaces() : null)
                .add("Software", software()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "associatedWithJob":
            return Optional.ofNullable(clazz.cast(associatedWithJob()));
        case "deviceCapacities":
            return Optional.ofNullable(clazz.cast(deviceCapacities()));
        case "deviceState":
            return Optional.ofNullable(clazz.cast(deviceStateAsString()));
        case "deviceType":
            return Optional.ofNullable(clazz.cast(deviceType()));
        case "lastReachedOutAt":
            return Optional.ofNullable(clazz.cast(lastReachedOutAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "managedDeviceArn":
            return Optional.ofNullable(clazz.cast(managedDeviceArn()));
        case "managedDeviceId":
            return Optional.ofNullable(clazz.cast(managedDeviceId()));
        case "physicalNetworkInterfaces":
            return Optional.ofNullable(clazz.cast(physicalNetworkInterfaces()));
        case "software":
            return Optional.ofNullable(clazz.cast(software()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDeviceResponse, T> g) {
        return obj -> g.apply((DescribeDeviceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnowDeviceManagementResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDeviceResponse> {
        /**
         * <p>
         * The ID of the job used when ordering the device.
         * </p>
         * 
         * @param associatedWithJob
         *        The ID of the job used when ordering the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedWithJob(String associatedWithJob);

        /**
         * <p>
         * The hardware specifications of the device.
         * </p>
         * 
         * @param deviceCapacities
         *        The hardware specifications of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceCapacities(Collection<Capacity> deviceCapacities);

        /**
         * <p>
         * The hardware specifications of the device.
         * </p>
         * 
         * @param deviceCapacities
         *        The hardware specifications of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceCapacities(Capacity... deviceCapacities);

        /**
         * <p>
         * The hardware specifications of the device.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Capacity>.Builder} avoiding the need to
         * create one manually via {@link List<Capacity>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Capacity>.Builder#build()} is called immediately and its
         * result is passed to {@link #deviceCapacities(List<Capacity>)}.
         * 
         * @param deviceCapacities
         *        a consumer that will call methods on {@link List<Capacity>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceCapacities(List<Capacity>)
         */
        Builder deviceCapacities(Consumer<Capacity.Builder>... deviceCapacities);

        /**
         * <p>
         * The current state of the device.
         * </p>
         * 
         * @param deviceState
         *        The current state of the device.
         * @see UnlockState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UnlockState
         */
        Builder deviceState(String deviceState);

        /**
         * <p>
         * The current state of the device.
         * </p>
         * 
         * @param deviceState
         *        The current state of the device.
         * @see UnlockState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UnlockState
         */
        Builder deviceState(UnlockState deviceState);

        /**
         * <p>
         * The type of Amazon Web Services Snow Family device.
         * </p>
         * 
         * @param deviceType
         *        The type of Amazon Web Services Snow Family device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceType(String deviceType);

        /**
         * <p>
         * When the device last contacted the Amazon Web Services Cloud. Indicates that the device is online.
         * </p>
         * 
         * @param lastReachedOutAt
         *        When the device last contacted the Amazon Web Services Cloud. Indicates that the device is online.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastReachedOutAt(Instant lastReachedOutAt);

        /**
         * <p>
         * When the device last pushed an update to the Amazon Web Services Cloud. Indicates when the device cache was
         * refreshed.
         * </p>
         * 
         * @param lastUpdatedAt
         *        When the device last pushed an update to the Amazon Web Services Cloud. Indicates when the device
         *        cache was refreshed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the device.
         * </p>
         * 
         * @param managedDeviceArn
         *        The Amazon Resource Name (ARN) of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedDeviceArn(String managedDeviceArn);

        /**
         * <p>
         * The ID of the device that you checked the information for.
         * </p>
         * 
         * @param managedDeviceId
         *        The ID of the device that you checked the information for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedDeviceId(String managedDeviceId);

        /**
         * <p>
         * The network interfaces available on the device.
         * </p>
         * 
         * @param physicalNetworkInterfaces
         *        The network interfaces available on the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalNetworkInterfaces(Collection<PhysicalNetworkInterface> physicalNetworkInterfaces);

        /**
         * <p>
         * The network interfaces available on the device.
         * </p>
         * 
         * @param physicalNetworkInterfaces
         *        The network interfaces available on the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalNetworkInterfaces(PhysicalNetworkInterface... physicalNetworkInterfaces);

        /**
         * <p>
         * The network interfaces available on the device.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PhysicalNetworkInterface>.Builder} avoiding
         * the need to create one manually via {@link List<PhysicalNetworkInterface>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PhysicalNetworkInterface>.Builder#build()} is called
         * immediately and its result is passed to {@link #physicalNetworkInterfaces(List<PhysicalNetworkInterface>)}.
         * 
         * @param physicalNetworkInterfaces
         *        a consumer that will call methods on {@link List<PhysicalNetworkInterface>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #physicalNetworkInterfaces(List<PhysicalNetworkInterface>)
         */
        Builder physicalNetworkInterfaces(Consumer<PhysicalNetworkInterface.Builder>... physicalNetworkInterfaces);

        /**
         * <p>
         * The software installed on the device.
         * </p>
         * 
         * @param software
         *        The software installed on the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder software(SoftwareInformation software);

        /**
         * <p>
         * The software installed on the device.
         * </p>
         * This is a convenience that creates an instance of the {@link SoftwareInformation.Builder} avoiding the need
         * to create one manually via {@link SoftwareInformation#builder()}.
         *
         * When the {@link Consumer} completes, {@link SoftwareInformation.Builder#build()} is called immediately and
         * its result is passed to {@link #software(SoftwareInformation)}.
         * 
         * @param software
         *        a consumer that will call methods on {@link SoftwareInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #software(SoftwareInformation)
         */
        default Builder software(Consumer<SoftwareInformation.Builder> software) {
            return software(SoftwareInformation.builder().applyMutation(software).build());
        }

        /**
         * <p>
         * Optional metadata that you assign to a resource. You can use tags to categorize a resource in different ways,
         * such as by purpose, owner, or environment.
         * </p>
         * 
         * @param tags
         *        Optional metadata that you assign to a resource. You can use tags to categorize a resource in
         *        different ways, such as by purpose, owner, or environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends SnowDeviceManagementResponse.BuilderImpl implements Builder {
        private String associatedWithJob;

        private List<Capacity> deviceCapacities = DefaultSdkAutoConstructList.getInstance();

        private String deviceState;

        private String deviceType;

        private Instant lastReachedOutAt;

        private Instant lastUpdatedAt;

        private String managedDeviceArn;

        private String managedDeviceId;

        private List<PhysicalNetworkInterface> physicalNetworkInterfaces = DefaultSdkAutoConstructList.getInstance();

        private SoftwareInformation software;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeviceResponse model) {
            super(model);
            associatedWithJob(model.associatedWithJob);
            deviceCapacities(model.deviceCapacities);
            deviceState(model.deviceState);
            deviceType(model.deviceType);
            lastReachedOutAt(model.lastReachedOutAt);
            lastUpdatedAt(model.lastUpdatedAt);
            managedDeviceArn(model.managedDeviceArn);
            managedDeviceId(model.managedDeviceId);
            physicalNetworkInterfaces(model.physicalNetworkInterfaces);
            software(model.software);
            tags(model.tags);
        }

        public final String getAssociatedWithJob() {
            return associatedWithJob;
        }

        public final void setAssociatedWithJob(String associatedWithJob) {
            this.associatedWithJob = associatedWithJob;
        }

        @Override
        @Transient
        public final Builder associatedWithJob(String associatedWithJob) {
            this.associatedWithJob = associatedWithJob;
            return this;
        }

        public final List<Capacity.Builder> getDeviceCapacities() {
            List<Capacity.Builder> result = CapacityListCopier.copyToBuilder(this.deviceCapacities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeviceCapacities(Collection<Capacity.BuilderImpl> deviceCapacities) {
            this.deviceCapacities = CapacityListCopier.copyFromBuilder(deviceCapacities);
        }

        @Override
        @Transient
        public final Builder deviceCapacities(Collection<Capacity> deviceCapacities) {
            this.deviceCapacities = CapacityListCopier.copy(deviceCapacities);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder deviceCapacities(Capacity... deviceCapacities) {
            deviceCapacities(Arrays.asList(deviceCapacities));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder deviceCapacities(Consumer<Capacity.Builder>... deviceCapacities) {
            deviceCapacities(Stream.of(deviceCapacities).map(c -> Capacity.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDeviceState() {
            return deviceState;
        }

        public final void setDeviceState(String deviceState) {
            this.deviceState = deviceState;
        }

        @Override
        @Transient
        public final Builder deviceState(String deviceState) {
            this.deviceState = deviceState;
            return this;
        }

        @Override
        @Transient
        public final Builder deviceState(UnlockState deviceState) {
            this.deviceState(deviceState == null ? null : deviceState.toString());
            return this;
        }

        public final String getDeviceType() {
            return deviceType;
        }

        public final void setDeviceType(String deviceType) {
            this.deviceType = deviceType;
        }

        @Override
        @Transient
        public final Builder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public final Instant getLastReachedOutAt() {
            return lastReachedOutAt;
        }

        public final void setLastReachedOutAt(Instant lastReachedOutAt) {
            this.lastReachedOutAt = lastReachedOutAt;
        }

        @Override
        @Transient
        public final Builder lastReachedOutAt(Instant lastReachedOutAt) {
            this.lastReachedOutAt = lastReachedOutAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        @Transient
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getManagedDeviceArn() {
            return managedDeviceArn;
        }

        public final void setManagedDeviceArn(String managedDeviceArn) {
            this.managedDeviceArn = managedDeviceArn;
        }

        @Override
        @Transient
        public final Builder managedDeviceArn(String managedDeviceArn) {
            this.managedDeviceArn = managedDeviceArn;
            return this;
        }

        public final String getManagedDeviceId() {
            return managedDeviceId;
        }

        public final void setManagedDeviceId(String managedDeviceId) {
            this.managedDeviceId = managedDeviceId;
        }

        @Override
        @Transient
        public final Builder managedDeviceId(String managedDeviceId) {
            this.managedDeviceId = managedDeviceId;
            return this;
        }

        public final List<PhysicalNetworkInterface.Builder> getPhysicalNetworkInterfaces() {
            List<PhysicalNetworkInterface.Builder> result = PhysicalNetworkInterfaceListCopier
                    .copyToBuilder(this.physicalNetworkInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhysicalNetworkInterfaces(Collection<PhysicalNetworkInterface.BuilderImpl> physicalNetworkInterfaces) {
            this.physicalNetworkInterfaces = PhysicalNetworkInterfaceListCopier.copyFromBuilder(physicalNetworkInterfaces);
        }

        @Override
        @Transient
        public final Builder physicalNetworkInterfaces(Collection<PhysicalNetworkInterface> physicalNetworkInterfaces) {
            this.physicalNetworkInterfaces = PhysicalNetworkInterfaceListCopier.copy(physicalNetworkInterfaces);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder physicalNetworkInterfaces(PhysicalNetworkInterface... physicalNetworkInterfaces) {
            physicalNetworkInterfaces(Arrays.asList(physicalNetworkInterfaces));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder physicalNetworkInterfaces(Consumer<PhysicalNetworkInterface.Builder>... physicalNetworkInterfaces) {
            physicalNetworkInterfaces(Stream.of(physicalNetworkInterfaces)
                    .map(c -> PhysicalNetworkInterface.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final SoftwareInformation.Builder getSoftware() {
            return software != null ? software.toBuilder() : null;
        }

        public final void setSoftware(SoftwareInformation.BuilderImpl software) {
            this.software = software != null ? software.build() : null;
        }

        @Override
        @Transient
        public final Builder software(SoftwareInformation software) {
            this.software = software;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public DescribeDeviceResponse build() {
            return new DescribeDeviceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
