/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowdevicemanagement.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeExecutionResponse extends SnowDeviceManagementResponse implements
        ToCopyableBuilder<DescribeExecutionResponse.Builder, DescribeExecutionResponse> {
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionId").getter(getter(DescribeExecutionResponse::executionId))
            .setter(setter(Builder::executionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionId").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt").getter(getter(DescribeExecutionResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final SdkField<String> MANAGED_DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("managedDeviceId").getter(getter(DescribeExecutionResponse::managedDeviceId))
            .setter(setter(Builder::managedDeviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedDeviceId").build()).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedAt").getter(getter(DescribeExecutionResponse::startedAt)).setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(DescribeExecutionResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("taskId")
            .getter(getter(DescribeExecutionResponse::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ID_FIELD,
            LAST_UPDATED_AT_FIELD, MANAGED_DEVICE_ID_FIELD, STARTED_AT_FIELD, STATE_FIELD, TASK_ID_FIELD));

    private final String executionId;

    private final Instant lastUpdatedAt;

    private final String managedDeviceId;

    private final Instant startedAt;

    private final String state;

    private final String taskId;

    private DescribeExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.executionId = builder.executionId;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.managedDeviceId = builder.managedDeviceId;
        this.startedAt = builder.startedAt;
        this.state = builder.state;
        this.taskId = builder.taskId;
    }

    /**
     * <p>
     * The ID of the execution.
     * </p>
     * 
     * @return The ID of the execution.
     */
    public final String executionId() {
        return executionId;
    }

    /**
     * <p>
     * When the status of the execution was last updated.
     * </p>
     * 
     * @return When the status of the execution was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The ID of the managed device that the task is being executed on.
     * </p>
     * 
     * @return The ID of the managed device that the task is being executed on.
     */
    public final String managedDeviceId() {
        return managedDeviceId;
    }

    /**
     * <p>
     * When the execution began.
     * </p>
     * 
     * @return When the execution began.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The current state of the execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ExecutionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the execution.
     * @see ExecutionState
     */
    public final ExecutionState state() {
        return ExecutionState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ExecutionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the execution.
     * @see ExecutionState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The ID of the task being executed on the device.
     * </p>
     * 
     * @return The ID of the task being executed on the device.
     */
    public final String taskId() {
        return taskId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(executionId());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(managedDeviceId());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExecutionResponse)) {
            return false;
        }
        DescribeExecutionResponse other = (DescribeExecutionResponse) obj;
        return Objects.equals(executionId(), other.executionId()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(managedDeviceId(), other.managedDeviceId()) && Objects.equals(startedAt(), other.startedAt())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(taskId(), other.taskId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeExecutionResponse").add("ExecutionId", executionId())
                .add("LastUpdatedAt", lastUpdatedAt()).add("ManagedDeviceId", managedDeviceId()).add("StartedAt", startedAt())
                .add("State", stateAsString()).add("TaskId", taskId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "executionId":
            return Optional.ofNullable(clazz.cast(executionId()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "managedDeviceId":
            return Optional.ofNullable(clazz.cast(managedDeviceId()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "taskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeExecutionResponse, T> g) {
        return obj -> g.apply((DescribeExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnowDeviceManagementResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeExecutionResponse> {
        /**
         * <p>
         * The ID of the execution.
         * </p>
         * 
         * @param executionId
         *        The ID of the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionId(String executionId);

        /**
         * <p>
         * When the status of the execution was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        When the status of the execution was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The ID of the managed device that the task is being executed on.
         * </p>
         * 
         * @param managedDeviceId
         *        The ID of the managed device that the task is being executed on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedDeviceId(String managedDeviceId);

        /**
         * <p>
         * When the execution began.
         * </p>
         * 
         * @param startedAt
         *        When the execution began.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The current state of the execution.
         * </p>
         * 
         * @param state
         *        The current state of the execution.
         * @see ExecutionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the execution.
         * </p>
         * 
         * @param state
         *        The current state of the execution.
         * @see ExecutionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionState
         */
        Builder state(ExecutionState state);

        /**
         * <p>
         * The ID of the task being executed on the device.
         * </p>
         * 
         * @param taskId
         *        The ID of the task being executed on the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);
    }

    static final class BuilderImpl extends SnowDeviceManagementResponse.BuilderImpl implements Builder {
        private String executionId;

        private Instant lastUpdatedAt;

        private String managedDeviceId;

        private Instant startedAt;

        private String state;

        private String taskId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExecutionResponse model) {
            super(model);
            executionId(model.executionId);
            lastUpdatedAt(model.lastUpdatedAt);
            managedDeviceId(model.managedDeviceId);
            startedAt(model.startedAt);
            state(model.state);
            taskId(model.taskId);
        }

        public final String getExecutionId() {
            return executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        @Transient
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        @Transient
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getManagedDeviceId() {
            return managedDeviceId;
        }

        public final void setManagedDeviceId(String managedDeviceId) {
            this.managedDeviceId = managedDeviceId;
        }

        @Override
        @Transient
        public final Builder managedDeviceId(String managedDeviceId) {
            this.managedDeviceId = managedDeviceId;
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        @Transient
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(ExecutionState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getTaskId() {
            return taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        @Transient
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        @Override
        public DescribeExecutionResponse build() {
            return new DescribeExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
