/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowdevicemanagement.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTaskResponse extends SnowDeviceManagementResponse implements
        ToCopyableBuilder<DescribeTaskResponse.Builder, DescribeTaskResponse> {
    private static final SdkField<Instant> COMPLETED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("completedAt").getter(getter(DescribeTaskResponse::completedAt)).setter(setter(Builder::completedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completedAt").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(DescribeTaskResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(DescribeTaskResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt").getter(getter(DescribeTaskResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(DescribeTaskResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(DescribeTaskResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> TARGETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("targets")
            .getter(getter(DescribeTaskResponse::targets))
            .setter(setter(Builder::targets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TASK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskArn").getter(getter(DescribeTaskResponse::taskArn)).setter(setter(Builder::taskArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskArn").build()).build();

    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("taskId")
            .getter(getter(DescribeTaskResponse::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETED_AT_FIELD,
            CREATED_AT_FIELD, DESCRIPTION_FIELD, LAST_UPDATED_AT_FIELD, STATE_FIELD, TAGS_FIELD, TARGETS_FIELD, TASK_ARN_FIELD,
            TASK_ID_FIELD));

    private final Instant completedAt;

    private final Instant createdAt;

    private final String description;

    private final Instant lastUpdatedAt;

    private final String state;

    private final Map<String, String> tags;

    private final List<String> targets;

    private final String taskArn;

    private final String taskId;

    private DescribeTaskResponse(BuilderImpl builder) {
        super(builder);
        this.completedAt = builder.completedAt;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.state = builder.state;
        this.tags = builder.tags;
        this.targets = builder.targets;
        this.taskArn = builder.taskArn;
        this.taskId = builder.taskId;
    }

    /**
     * <p>
     * When the task was completed.
     * </p>
     * 
     * @return When the task was completed.
     */
    public final Instant completedAt() {
        return completedAt;
    }

    /**
     * <p>
     * When the <code>CreateTask</code> operation was called.
     * </p>
     * 
     * @return When the <code>CreateTask</code> operation was called.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The description provided of the task and managed devices.
     * </p>
     * 
     * @return The description provided of the task and managed devices.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * When the state of the task was last updated.
     * </p>
     * 
     * @return When the state of the task was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The current state of the task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TaskState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the task.
     * @see TaskState
     */
    public final TaskState state() {
        return TaskState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TaskState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the task.
     * @see TaskState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Optional metadata that you assign to a resource. You can use tags to categorize a resource in different ways,
     * such as by purpose, owner, or environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Optional metadata that you assign to a resource. You can use tags to categorize a resource in different
     *         ways, such as by purpose, owner, or environment.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Targets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTargets() {
        return targets != null && !(targets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The managed devices that the task was sent to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargets} method.
     * </p>
     * 
     * @return The managed devices that the task was sent to.
     */
    public final List<String> targets() {
        return targets;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the task.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the task.
     */
    public final String taskArn() {
        return taskArn;
    }

    /**
     * <p>
     * The ID of the task.
     * </p>
     * 
     * @return The ID of the task.
     */
    public final String taskId() {
        return taskId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(completedAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargets() ? targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTaskResponse)) {
            return false;
        }
        DescribeTaskResponse other = (DescribeTaskResponse) obj;
        return Objects.equals(completedAt(), other.completedAt()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(description(), other.description()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(stateAsString(), other.stateAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasTargets() == other.hasTargets()
                && Objects.equals(targets(), other.targets()) && Objects.equals(taskArn(), other.taskArn())
                && Objects.equals(taskId(), other.taskId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTaskResponse").add("CompletedAt", completedAt()).add("CreatedAt", createdAt())
                .add("Description", description()).add("LastUpdatedAt", lastUpdatedAt()).add("State", stateAsString())
                .add("Tags", hasTags() ? tags() : null).add("Targets", hasTargets() ? targets() : null).add("TaskArn", taskArn())
                .add("TaskId", taskId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "completedAt":
            return Optional.ofNullable(clazz.cast(completedAt()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "taskArn":
            return Optional.ofNullable(clazz.cast(taskArn()));
        case "taskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTaskResponse, T> g) {
        return obj -> g.apply((DescribeTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnowDeviceManagementResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTaskResponse> {
        /**
         * <p>
         * When the task was completed.
         * </p>
         * 
         * @param completedAt
         *        When the task was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedAt(Instant completedAt);

        /**
         * <p>
         * When the <code>CreateTask</code> operation was called.
         * </p>
         * 
         * @param createdAt
         *        When the <code>CreateTask</code> operation was called.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The description provided of the task and managed devices.
         * </p>
         * 
         * @param description
         *        The description provided of the task and managed devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * When the state of the task was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        When the state of the task was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The current state of the task.
         * </p>
         * 
         * @param state
         *        The current state of the task.
         * @see TaskState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the task.
         * </p>
         * 
         * @param state
         *        The current state of the task.
         * @see TaskState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskState
         */
        Builder state(TaskState state);

        /**
         * <p>
         * Optional metadata that you assign to a resource. You can use tags to categorize a resource in different ways,
         * such as by purpose, owner, or environment.
         * </p>
         * 
         * @param tags
         *        Optional metadata that you assign to a resource. You can use tags to categorize a resource in
         *        different ways, such as by purpose, owner, or environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The managed devices that the task was sent to.
         * </p>
         * 
         * @param targets
         *        The managed devices that the task was sent to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<String> targets);

        /**
         * <p>
         * The managed devices that the task was sent to.
         * </p>
         * 
         * @param targets
         *        The managed devices that the task was sent to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(String... targets);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the task.
         * </p>
         * 
         * @param taskArn
         *        The Amazon Resource Name (ARN) of the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskArn(String taskArn);

        /**
         * <p>
         * The ID of the task.
         * </p>
         * 
         * @param taskId
         *        The ID of the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);
    }

    static final class BuilderImpl extends SnowDeviceManagementResponse.BuilderImpl implements Builder {
        private Instant completedAt;

        private Instant createdAt;

        private String description;

        private Instant lastUpdatedAt;

        private String state;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<String> targets = DefaultSdkAutoConstructList.getInstance();

        private String taskArn;

        private String taskId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTaskResponse model) {
            super(model);
            completedAt(model.completedAt);
            createdAt(model.createdAt);
            description(model.description);
            lastUpdatedAt(model.lastUpdatedAt);
            state(model.state);
            tags(model.tags);
            targets(model.targets);
            taskArn(model.taskArn);
            taskId(model.taskId);
        }

        public final Instant getCompletedAt() {
            return completedAt;
        }

        public final void setCompletedAt(Instant completedAt) {
            this.completedAt = completedAt;
        }

        @Override
        @Transient
        public final Builder completedAt(Instant completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        @Transient
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(TaskState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Collection<String> getTargets() {
            if (targets instanceof SdkAutoConstructList) {
                return null;
            }
            return targets;
        }

        public final void setTargets(Collection<String> targets) {
            this.targets = TargetListCopier.copy(targets);
        }

        @Override
        @Transient
        public final Builder targets(Collection<String> targets) {
            this.targets = TargetListCopier.copy(targets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder targets(String... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        public final String getTaskArn() {
            return taskArn;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        @Override
        @Transient
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final String getTaskId() {
            return taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        @Transient
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        @Override
        public DescribeTaskResponse build() {
            return new DescribeTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
