/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowdevicemanagement.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the software on the device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SoftwareInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<SoftwareInformation.Builder, SoftwareInformation> {
    private static final SdkField<String> INSTALL_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("installState").getter(getter(SoftwareInformation::installState)).setter(setter(Builder::installState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("installState").build()).build();

    private static final SdkField<String> INSTALLED_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("installedVersion").getter(getter(SoftwareInformation::installedVersion))
            .setter(setter(Builder::installedVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("installedVersion").build()).build();

    private static final SdkField<String> INSTALLING_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("installingVersion").getter(getter(SoftwareInformation::installingVersion))
            .setter(setter(Builder::installingVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("installingVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTALL_STATE_FIELD,
            INSTALLED_VERSION_FIELD, INSTALLING_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String installState;

    private final String installedVersion;

    private final String installingVersion;

    private SoftwareInformation(BuilderImpl builder) {
        this.installState = builder.installState;
        this.installedVersion = builder.installedVersion;
        this.installingVersion = builder.installingVersion;
    }

    /**
     * <p>
     * The state of the software that is installed or that is being installed on the device.
     * </p>
     * 
     * @return The state of the software that is installed or that is being installed on the device.
     */
    public final String installState() {
        return installState;
    }

    /**
     * <p>
     * The version of the software currently installed on the device.
     * </p>
     * 
     * @return The version of the software currently installed on the device.
     */
    public final String installedVersion() {
        return installedVersion;
    }

    /**
     * <p>
     * The version of the software being installed on the device.
     * </p>
     * 
     * @return The version of the software being installed on the device.
     */
    public final String installingVersion() {
        return installingVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(installState());
        hashCode = 31 * hashCode + Objects.hashCode(installedVersion());
        hashCode = 31 * hashCode + Objects.hashCode(installingVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SoftwareInformation)) {
            return false;
        }
        SoftwareInformation other = (SoftwareInformation) obj;
        return Objects.equals(installState(), other.installState())
                && Objects.equals(installedVersion(), other.installedVersion())
                && Objects.equals(installingVersion(), other.installingVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SoftwareInformation").add("InstallState", installState())
                .add("InstalledVersion", installedVersion()).add("InstallingVersion", installingVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "installState":
            return Optional.ofNullable(clazz.cast(installState()));
        case "installedVersion":
            return Optional.ofNullable(clazz.cast(installedVersion()));
        case "installingVersion":
            return Optional.ofNullable(clazz.cast(installingVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SoftwareInformation, T> g) {
        return obj -> g.apply((SoftwareInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SoftwareInformation> {
        /**
         * <p>
         * The state of the software that is installed or that is being installed on the device.
         * </p>
         * 
         * @param installState
         *        The state of the software that is installed or that is being installed on the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder installState(String installState);

        /**
         * <p>
         * The version of the software currently installed on the device.
         * </p>
         * 
         * @param installedVersion
         *        The version of the software currently installed on the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder installedVersion(String installedVersion);

        /**
         * <p>
         * The version of the software being installed on the device.
         * </p>
         * 
         * @param installingVersion
         *        The version of the software being installed on the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder installingVersion(String installingVersion);
    }

    static final class BuilderImpl implements Builder {
        private String installState;

        private String installedVersion;

        private String installingVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(SoftwareInformation model) {
            installState(model.installState);
            installedVersion(model.installedVersion);
            installingVersion(model.installingVersion);
        }

        public final String getInstallState() {
            return installState;
        }

        public final void setInstallState(String installState) {
            this.installState = installState;
        }

        @Override
        @Transient
        public final Builder installState(String installState) {
            this.installState = installState;
            return this;
        }

        public final String getInstalledVersion() {
            return installedVersion;
        }

        public final void setInstalledVersion(String installedVersion) {
            this.installedVersion = installedVersion;
        }

        @Override
        @Transient
        public final Builder installedVersion(String installedVersion) {
            this.installedVersion = installedVersion;
            return this;
        }

        public final String getInstallingVersion() {
            return installingVersion;
        }

        public final void setInstallingVersion(String installingVersion) {
            this.installingVersion = installingVersion;
        }

        @Override
        @Transient
        public final Builder installingVersion(String installingVersion) {
            this.installingVersion = installingVersion;
            return this;
        }

        @Override
        public SoftwareInformation build() {
            return new SoftwareInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
