/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowdevicemanagement.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ResourceSummary.getter(ResourceSummary::arn)).setter(ResourceSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(ResourceSummary.getter(ResourceSummary::id)).setter(ResourceSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(ResourceSummary.getter(ResourceSummary::resourceType)).setter(ResourceSummary.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD, RESOURCE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String id;
    private final String resourceType;

    private ResourceSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.resourceType = builder.resourceType;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceSummary)) {
            return false;
        }
        ResourceSummary other = (ResourceSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.resourceType(), other.resourceType());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceSummary").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("ResourceType", (Object)this.resourceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceSummary, T> g) {
        return obj -> g.apply((ResourceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceSummary model) {
            this.arn(model.arn);
            this.id(model.id);
            this.resourceType(model.resourceType);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        @Transient
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public ResourceSummary build() {
            return new ResourceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceSummary> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder resourceType(String var1);
    }
}

