/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowdevicemanagement.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.snowdevicemanagement.SnowDeviceManagementAsyncClient;
import software.amazon.awssdk.services.snowdevicemanagement.model.ListDeviceResourcesRequest;
import software.amazon.awssdk.services.snowdevicemanagement.model.ListDeviceResourcesResponse;
import software.amazon.awssdk.services.snowdevicemanagement.model.ResourceSummary;

public class ListDeviceResourcesPublisher
implements SdkPublisher<ListDeviceResourcesResponse> {
    private final SnowDeviceManagementAsyncClient client;
    private final ListDeviceResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDeviceResourcesPublisher(SnowDeviceManagementAsyncClient client, ListDeviceResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDeviceResourcesPublisher(SnowDeviceManagementAsyncClient client, ListDeviceResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDeviceResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDeviceResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResourceSummary> resources() {
        Function<ListDeviceResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.resources() != null) {
                return response.resources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDeviceResourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDeviceResourcesResponseFetcher
    implements AsyncPageFetcher<ListDeviceResourcesResponse> {
        private ListDeviceResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListDeviceResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDeviceResourcesResponse> nextPage(ListDeviceResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListDeviceResourcesPublisher.this.client.listDeviceResources(ListDeviceResourcesPublisher.this.firstRequest);
            }
            return ListDeviceResourcesPublisher.this.client.listDeviceResources((ListDeviceResourcesRequest)((Object)ListDeviceResourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

