/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowdevicemanagement;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.snowdevicemanagement.model.CancelTaskRequest;
import software.amazon.awssdk.services.snowdevicemanagement.model.CancelTaskResponse;
import software.amazon.awssdk.services.snowdevicemanagement.model.CreateTaskRequest;
import software.amazon.awssdk.services.snowdevicemanagement.model.CreateTaskResponse;
import software.amazon.awssdk.services.snowdevicemanagement.model.DescribeDeviceEc2InstancesRequest;
import software.amazon.awssdk.services.snowdevicemanagement.model.DescribeDeviceEc2InstancesResponse;
import software.amazon.awssdk.services.snowdevicemanagement.model.DescribeDeviceRequest;
import software.amazon.awssdk.services.snowdevicemanagement.model.DescribeDeviceResponse;
import software.amazon.awssdk.services.snowdevicemanagement.model.DescribeExecutionRequest;
import software.amazon.awssdk.services.snowdevicemanagement.model.DescribeExecutionResponse;
import software.amazon.awssdk.services.snowdevicemanagement.model.DescribeTaskRequest;
import software.amazon.awssdk.services.snowdevicemanagement.model.DescribeTaskResponse;
import software.amazon.awssdk.services.snowdevicemanagement.model.ListDeviceResourcesRequest;
import software.amazon.awssdk.services.snowdevicemanagement.model.ListDeviceResourcesResponse;
import software.amazon.awssdk.services.snowdevicemanagement.model.ListDevicesRequest;
import software.amazon.awssdk.services.snowdevicemanagement.model.ListDevicesResponse;
import software.amazon.awssdk.services.snowdevicemanagement.model.ListExecutionsRequest;
import software.amazon.awssdk.services.snowdevicemanagement.model.ListExecutionsResponse;
import software.amazon.awssdk.services.snowdevicemanagement.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.snowdevicemanagement.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.snowdevicemanagement.model.ListTasksRequest;
import software.amazon.awssdk.services.snowdevicemanagement.model.ListTasksResponse;
import software.amazon.awssdk.services.snowdevicemanagement.model.TagResourceRequest;
import software.amazon.awssdk.services.snowdevicemanagement.model.TagResourceResponse;
import software.amazon.awssdk.services.snowdevicemanagement.model.UntagResourceRequest;
import software.amazon.awssdk.services.snowdevicemanagement.model.UntagResourceResponse;
import software.amazon.awssdk.services.snowdevicemanagement.paginators.ListDeviceResourcesPublisher;
import software.amazon.awssdk.services.snowdevicemanagement.paginators.ListDevicesPublisher;
import software.amazon.awssdk.services.snowdevicemanagement.paginators.ListExecutionsPublisher;
import software.amazon.awssdk.services.snowdevicemanagement.paginators.ListTasksPublisher;

/**
 * Service client for accessing AWS Snow Device Management asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Amazon Web Services Snow Device Management documentation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SnowDeviceManagementAsyncClient extends AwsClient {
    String SERVICE_NAME = "snow-device-management";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "snow-device-management";

    /**
     * <p>
     * Sends a cancel request for a specified task. You can cancel a task only if it's still in a <code>QUEUED</code>
     * state. Tasks that are already running can't be cancelled.
     * </p>
     * <note>
     * <p>
     * A task might still run if it's processed from the queue before the <code>CancelTask</code> operation changes the
     * task's state.
     * </p>
     * </note>
     *
     * @param cancelTaskRequest
     * @return A Java Future containing the result of the CancelTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnowDeviceManagementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample SnowDeviceManagementAsyncClient.CancelTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/CancelTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelTaskResponse> cancelTask(CancelTaskRequest cancelTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends a cancel request for a specified task. You can cancel a task only if it's still in a <code>QUEUED</code>
     * state. Tasks that are already running can't be cancelled.
     * </p>
     * <note>
     * <p>
     * A task might still run if it's processed from the queue before the <code>CancelTask</code> operation changes the
     * task's state.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelTaskRequest.Builder} avoiding the need to
     * create one manually via {@link CancelTaskRequest#builder()}
     * </p>
     *
     * @param cancelTaskRequest
     *        A {@link Consumer} that will call methods on {@link CancelTaskInput.Builder} to create a request.
     * @return A Java Future containing the result of the CancelTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnowDeviceManagementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample SnowDeviceManagementAsyncClient.CancelTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/CancelTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelTaskResponse> cancelTask(Consumer<CancelTaskRequest.Builder> cancelTaskRequest) {
        return cancelTask(CancelTaskRequest.builder().applyMutation(cancelTaskRequest).build());
    }

    /**
     * <p>
     * Instructs one or more devices to start a task, such as unlocking or rebooting.
     * </p>
     *
     * @param createTaskRequest
     * @return A Java Future containing the result of the CreateTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnowDeviceManagementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample SnowDeviceManagementAsyncClient.CreateTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/CreateTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTaskResponse> createTask(CreateTaskRequest createTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Instructs one or more devices to start a task, such as unlocking or rebooting.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTaskRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTaskRequest#builder()}
     * </p>
     *
     * @param createTaskRequest
     *        A {@link Consumer} that will call methods on {@link CreateTaskInput.Builder} to create a request.
     * @return A Java Future containing the result of the CreateTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnowDeviceManagementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample SnowDeviceManagementAsyncClient.CreateTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/CreateTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTaskResponse> createTask(Consumer<CreateTaskRequest.Builder> createTaskRequest) {
        return createTask(CreateTaskRequest.builder().applyMutation(createTaskRequest).build());
    }

    /**
     * <p>
     * Checks device-specific information, such as the device type, software version, IP addresses, and lock status.
     * </p>
     *
     * @param describeDeviceRequest
     * @return A Java Future containing the result of the DescribeDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnowDeviceManagementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample SnowDeviceManagementAsyncClient.DescribeDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/DescribeDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDeviceResponse> describeDevice(DescribeDeviceRequest describeDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Checks device-specific information, such as the device type, software version, IP addresses, and lock status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeDeviceRequest#builder()}
     * </p>
     *
     * @param describeDeviceRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDeviceInput.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnowDeviceManagementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample SnowDeviceManagementAsyncClient.DescribeDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/DescribeDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDeviceResponse> describeDevice(Consumer<DescribeDeviceRequest.Builder> describeDeviceRequest) {
        return describeDevice(DescribeDeviceRequest.builder().applyMutation(describeDeviceRequest).build());
    }

    /**
     * <p>
     * Checks the current state of the Amazon EC2 instances. The output is similar to <code>describeDevice</code>, but
     * the results are sourced from the device cache in the Amazon Web Services Cloud and include a subset of the
     * available fields.
     * </p>
     *
     * @param describeDeviceEc2InstancesRequest
     * @return A Java Future containing the result of the DescribeDeviceEc2Instances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnowDeviceManagementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample SnowDeviceManagementAsyncClient.DescribeDeviceEc2Instances
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/DescribeDeviceEc2Instances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDeviceEc2InstancesResponse> describeDeviceEc2Instances(
            DescribeDeviceEc2InstancesRequest describeDeviceEc2InstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Checks the current state of the Amazon EC2 instances. The output is similar to <code>describeDevice</code>, but
     * the results are sourced from the device cache in the Amazon Web Services Cloud and include a subset of the
     * available fields.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDeviceEc2InstancesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDeviceEc2InstancesRequest#builder()}
     * </p>
     *
     * @param describeDeviceEc2InstancesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDeviceEc2Input.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeDeviceEc2Instances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnowDeviceManagementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample SnowDeviceManagementAsyncClient.DescribeDeviceEc2Instances
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/DescribeDeviceEc2Instances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDeviceEc2InstancesResponse> describeDeviceEc2Instances(
            Consumer<DescribeDeviceEc2InstancesRequest.Builder> describeDeviceEc2InstancesRequest) {
        return describeDeviceEc2Instances(DescribeDeviceEc2InstancesRequest.builder()
                .applyMutation(describeDeviceEc2InstancesRequest).build());
    }

    /**
     * <p>
     * Checks the status of a remote task running on one or more target devices.
     * </p>
     *
     * @param describeExecutionRequest
     * @return A Java Future containing the result of the DescribeExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnowDeviceManagementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample SnowDeviceManagementAsyncClient.DescribeExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/DescribeExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeExecutionResponse> describeExecution(DescribeExecutionRequest describeExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Checks the status of a remote task running on one or more target devices.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeExecutionRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeExecutionRequest#builder()}
     * </p>
     *
     * @param describeExecutionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeExecutionInput.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnowDeviceManagementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample SnowDeviceManagementAsyncClient.DescribeExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/DescribeExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeExecutionResponse> describeExecution(
            Consumer<DescribeExecutionRequest.Builder> describeExecutionRequest) {
        return describeExecution(DescribeExecutionRequest.builder().applyMutation(describeExecutionRequest).build());
    }

    /**
     * <p>
     * Checks the metadata for a given task on a device.
     * </p>
     *
     * @param describeTaskRequest
     * @return A Java Future containing the result of the DescribeTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnowDeviceManagementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample SnowDeviceManagementAsyncClient.DescribeTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/DescribeTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTaskResponse> describeTask(DescribeTaskRequest describeTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Checks the metadata for a given task on a device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTaskRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTaskRequest#builder()}
     * </p>
     *
     * @param describeTaskRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTaskInput.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnowDeviceManagementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample SnowDeviceManagementAsyncClient.DescribeTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/DescribeTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTaskResponse> describeTask(Consumer<DescribeTaskRequest.Builder> describeTaskRequest) {
        return describeTask(DescribeTaskRequest.builder().applyMutation(describeTaskRequest).build());
    }

    /**
     * <p>
     * Returns a list of the Amazon Web Services resources available for a device. Currently, Amazon EC2 instances are
     * the only supported resource type.
     * </p>
     *
     * @param listDeviceResourcesRequest
     * @return A Java Future containing the result of the ListDeviceResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnowDeviceManagementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample SnowDeviceManagementAsyncClient.ListDeviceResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListDeviceResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDeviceResourcesResponse> listDeviceResources(
            ListDeviceResourcesRequest listDeviceResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the Amazon Web Services resources available for a device. Currently, Amazon EC2 instances are
     * the only supported resource type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeviceResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeviceResourcesRequest#builder()}
     * </p>
     *
     * @param listDeviceResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListDeviceResourcesInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListDeviceResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnowDeviceManagementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample SnowDeviceManagementAsyncClient.ListDeviceResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListDeviceResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDeviceResourcesResponse> listDeviceResources(
            Consumer<ListDeviceResourcesRequest.Builder> listDeviceResourcesRequest) {
        return listDeviceResources(ListDeviceResourcesRequest.builder().applyMutation(listDeviceResourcesRequest).build());
    }

    /**
     * <p>
     * Returns a list of the Amazon Web Services resources available for a device. Currently, Amazon EC2 instances are
     * the only supported resource type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeviceResources(software.amazon.awssdk.services.snowdevicemanagement.model.ListDeviceResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowdevicemanagement.paginators.ListDeviceResourcesPublisher publisher = client.listDeviceResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowdevicemanagement.paginators.ListDeviceResourcesPublisher publisher = client.listDeviceResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.snowdevicemanagement.model.ListDeviceResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.snowdevicemanagement.model.ListDeviceResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeviceResources(software.amazon.awssdk.services.snowdevicemanagement.model.ListDeviceResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDeviceResourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnowDeviceManagementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample SnowDeviceManagementAsyncClient.ListDeviceResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListDeviceResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceResourcesPublisher listDeviceResourcesPaginator(ListDeviceResourcesRequest listDeviceResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the Amazon Web Services resources available for a device. Currently, Amazon EC2 instances are
     * the only supported resource type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeviceResources(software.amazon.awssdk.services.snowdevicemanagement.model.ListDeviceResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowdevicemanagement.paginators.ListDeviceResourcesPublisher publisher = client.listDeviceResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowdevicemanagement.paginators.ListDeviceResourcesPublisher publisher = client.listDeviceResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.snowdevicemanagement.model.ListDeviceResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.snowdevicemanagement.model.ListDeviceResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeviceResources(software.amazon.awssdk.services.snowdevicemanagement.model.ListDeviceResourcesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeviceResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeviceResourcesRequest#builder()}
     * </p>
     *
     * @param listDeviceResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListDeviceResourcesInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnowDeviceManagementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample SnowDeviceManagementAsyncClient.ListDeviceResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListDeviceResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceResourcesPublisher listDeviceResourcesPaginator(
            Consumer<ListDeviceResourcesRequest.Builder> listDeviceResourcesRequest) {
        return listDeviceResourcesPaginator(ListDeviceResourcesRequest.builder().applyMutation(listDeviceResourcesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of all devices on your Amazon Web Services account that have Amazon Web Services Snow Device
     * Management enabled in the Amazon Web Services Region where the command is run.
     * </p>
     *
     * @param listDevicesRequest
     * @return A Java Future containing the result of the ListDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnowDeviceManagementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample SnowDeviceManagementAsyncClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDevicesResponse> listDevices(ListDevicesRequest listDevicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all devices on your Amazon Web Services account that have Amazon Web Services Snow Device
     * Management enabled in the Amazon Web Services Region where the command is run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListDevicesRequest#builder()}
     * </p>
     *
     * @param listDevicesRequest
     *        A {@link Consumer} that will call methods on {@link ListDevicesInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnowDeviceManagementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample SnowDeviceManagementAsyncClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDevicesResponse> listDevices(Consumer<ListDevicesRequest.Builder> listDevicesRequest) {
        return listDevices(ListDevicesRequest.builder().applyMutation(listDevicesRequest).build());
    }

    /**
     * <p>
     * Returns a list of all devices on your Amazon Web Services account that have Amazon Web Services Snow Device
     * Management enabled in the Amazon Web Services Region where the command is run.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDevices(software.amazon.awssdk.services.snowdevicemanagement.model.ListDevicesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowdevicemanagement.paginators.ListDevicesPublisher publisher = client.listDevicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowdevicemanagement.paginators.ListDevicesPublisher publisher = client.listDevicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.snowdevicemanagement.model.ListDevicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.snowdevicemanagement.model.ListDevicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevices(software.amazon.awssdk.services.snowdevicemanagement.model.ListDevicesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDevicesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnowDeviceManagementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample SnowDeviceManagementAsyncClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDevicesPublisher listDevicesPaginator(ListDevicesRequest listDevicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all devices on your Amazon Web Services account that have Amazon Web Services Snow Device
     * Management enabled in the Amazon Web Services Region where the command is run.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDevices(software.amazon.awssdk.services.snowdevicemanagement.model.ListDevicesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowdevicemanagement.paginators.ListDevicesPublisher publisher = client.listDevicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowdevicemanagement.paginators.ListDevicesPublisher publisher = client.listDevicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.snowdevicemanagement.model.ListDevicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.snowdevicemanagement.model.ListDevicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevices(software.amazon.awssdk.services.snowdevicemanagement.model.ListDevicesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListDevicesRequest#builder()}
     * </p>
     *
     * @param listDevicesRequest
     *        A {@link Consumer} that will call methods on {@link ListDevicesInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnowDeviceManagementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample SnowDeviceManagementAsyncClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDevicesPublisher listDevicesPaginator(Consumer<ListDevicesRequest.Builder> listDevicesRequest) {
        return listDevicesPaginator(ListDevicesRequest.builder().applyMutation(listDevicesRequest).build());
    }

    /**
     * <p>
     * Returns the status of tasks for one or more target devices.
     * </p>
     *
     * @param listExecutionsRequest
     * @return A Java Future containing the result of the ListExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnowDeviceManagementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample SnowDeviceManagementAsyncClient.ListExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListExecutionsResponse> listExecutions(ListExecutionsRequest listExecutionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the status of tasks for one or more target devices.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExecutionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExecutionsRequest#builder()}
     * </p>
     *
     * @param listExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link ListExecutionsInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnowDeviceManagementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample SnowDeviceManagementAsyncClient.ListExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListExecutionsResponse> listExecutions(Consumer<ListExecutionsRequest.Builder> listExecutionsRequest) {
        return listExecutions(ListExecutionsRequest.builder().applyMutation(listExecutionsRequest).build());
    }

    /**
     * <p>
     * Returns the status of tasks for one or more target devices.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExecutions(software.amazon.awssdk.services.snowdevicemanagement.model.ListExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowdevicemanagement.paginators.ListExecutionsPublisher publisher = client.listExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowdevicemanagement.paginators.ListExecutionsPublisher publisher = client.listExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.snowdevicemanagement.model.ListExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.snowdevicemanagement.model.ListExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExecutions(software.amazon.awssdk.services.snowdevicemanagement.model.ListExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listExecutionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnowDeviceManagementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample SnowDeviceManagementAsyncClient.ListExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListExecutionsPublisher listExecutionsPaginator(ListExecutionsRequest listExecutionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the status of tasks for one or more target devices.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExecutions(software.amazon.awssdk.services.snowdevicemanagement.model.ListExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowdevicemanagement.paginators.ListExecutionsPublisher publisher = client.listExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowdevicemanagement.paginators.ListExecutionsPublisher publisher = client.listExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.snowdevicemanagement.model.ListExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.snowdevicemanagement.model.ListExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExecutions(software.amazon.awssdk.services.snowdevicemanagement.model.ListExecutionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExecutionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExecutionsRequest#builder()}
     * </p>
     *
     * @param listExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link ListExecutionsInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnowDeviceManagementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample SnowDeviceManagementAsyncClient.ListExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListExecutionsPublisher listExecutionsPaginator(Consumer<ListExecutionsRequest.Builder> listExecutionsRequest) {
        return listExecutionsPaginator(ListExecutionsRequest.builder().applyMutation(listExecutionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of tags for a managed device or task.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnowDeviceManagementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample SnowDeviceManagementAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags for a managed device or task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnowDeviceManagementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample SnowDeviceManagementAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Returns a list of tasks that can be filtered by state.
     * </p>
     *
     * @param listTasksRequest
     * @return A Java Future containing the result of the ListTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnowDeviceManagementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample SnowDeviceManagementAsyncClient.ListTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTasksResponse> listTasks(ListTasksRequest listTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tasks that can be filtered by state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTasksRequest.Builder} avoiding the need to
     * create one manually via {@link ListTasksRequest#builder()}
     * </p>
     *
     * @param listTasksRequest
     *        A {@link Consumer} that will call methods on {@link ListTasksInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnowDeviceManagementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample SnowDeviceManagementAsyncClient.ListTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTasksResponse> listTasks(Consumer<ListTasksRequest.Builder> listTasksRequest) {
        return listTasks(ListTasksRequest.builder().applyMutation(listTasksRequest).build());
    }

    /**
     * <p>
     * Returns a list of tasks that can be filtered by state.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTasks(software.amazon.awssdk.services.snowdevicemanagement.model.ListTasksRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowdevicemanagement.paginators.ListTasksPublisher publisher = client.listTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowdevicemanagement.paginators.ListTasksPublisher publisher = client.listTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.snowdevicemanagement.model.ListTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.snowdevicemanagement.model.ListTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTasks(software.amazon.awssdk.services.snowdevicemanagement.model.ListTasksRequest)} operation.</b>
     * </p>
     *
     * @param listTasksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnowDeviceManagementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample SnowDeviceManagementAsyncClient.ListTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTasksPublisher listTasksPaginator(ListTasksRequest listTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tasks that can be filtered by state.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTasks(software.amazon.awssdk.services.snowdevicemanagement.model.ListTasksRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowdevicemanagement.paginators.ListTasksPublisher publisher = client.listTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowdevicemanagement.paginators.ListTasksPublisher publisher = client.listTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.snowdevicemanagement.model.ListTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.snowdevicemanagement.model.ListTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTasks(software.amazon.awssdk.services.snowdevicemanagement.model.ListTasksRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTasksRequest.Builder} avoiding the need to
     * create one manually via {@link ListTasksRequest#builder()}
     * </p>
     *
     * @param listTasksRequest
     *        A {@link Consumer} that will call methods on {@link ListTasksInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnowDeviceManagementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample SnowDeviceManagementAsyncClient.ListTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTasksPublisher listTasksPaginator(Consumer<ListTasksRequest.Builder> listTasksRequest) {
        return listTasksPaginator(ListTasksRequest.builder().applyMutation(listTasksRequest).build());
    }

    /**
     * <p>
     * Adds or replaces tags on a device or task.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnowDeviceManagementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample SnowDeviceManagementAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or replaces tags on a device or task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceInput.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnowDeviceManagementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample SnowDeviceManagementAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag from a device or task.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnowDeviceManagementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample SnowDeviceManagementAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag from a device or task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceInput.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnowDeviceManagementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample SnowDeviceManagementAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    @Override
    default SnowDeviceManagementServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link SnowDeviceManagementAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SnowDeviceManagementAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SnowDeviceManagementAsyncClient}.
     */
    static SnowDeviceManagementAsyncClientBuilder builder() {
        return new DefaultSnowDeviceManagementAsyncClientBuilder();
    }
}
