/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowdevicemanagement.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifying information about the device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceSummary implements SdkPojo, Serializable, ToCopyableBuilder<DeviceSummary.Builder, DeviceSummary> {
    private static final SdkField<String> ASSOCIATED_WITH_JOB_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("associatedWithJob").getter(getter(DeviceSummary::associatedWithJob))
            .setter(setter(Builder::associatedWithJob))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedWithJob").build()).build();

    private static final SdkField<String> MANAGED_DEVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("managedDeviceArn").getter(getter(DeviceSummary::managedDeviceArn))
            .setter(setter(Builder::managedDeviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedDeviceArn").build()).build();

    private static final SdkField<String> MANAGED_DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("managedDeviceId").getter(getter(DeviceSummary::managedDeviceId))
            .setter(setter(Builder::managedDeviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedDeviceId").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(DeviceSummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATED_WITH_JOB_FIELD,
            MANAGED_DEVICE_ARN_FIELD, MANAGED_DEVICE_ID_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String associatedWithJob;

    private final String managedDeviceArn;

    private final String managedDeviceId;

    private final Map<String, String> tags;

    private DeviceSummary(BuilderImpl builder) {
        this.associatedWithJob = builder.associatedWithJob;
        this.managedDeviceArn = builder.managedDeviceArn;
        this.managedDeviceId = builder.managedDeviceId;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the job used to order the device.
     * </p>
     * 
     * @return The ID of the job used to order the device.
     */
    public final String associatedWithJob() {
        return associatedWithJob;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the device.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the device.
     */
    public final String managedDeviceArn() {
        return managedDeviceArn;
    }

    /**
     * <p>
     * The ID of the device.
     * </p>
     * 
     * @return The ID of the device.
     */
    public final String managedDeviceId() {
        return managedDeviceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Optional metadata that you assign to a resource. You can use tags to categorize a resource in different ways,
     * such as by purpose, owner, or environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Optional metadata that you assign to a resource. You can use tags to categorize a resource in different
     *         ways, such as by purpose, owner, or environment.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associatedWithJob());
        hashCode = 31 * hashCode + Objects.hashCode(managedDeviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(managedDeviceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceSummary)) {
            return false;
        }
        DeviceSummary other = (DeviceSummary) obj;
        return Objects.equals(associatedWithJob(), other.associatedWithJob())
                && Objects.equals(managedDeviceArn(), other.managedDeviceArn())
                && Objects.equals(managedDeviceId(), other.managedDeviceId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeviceSummary").add("AssociatedWithJob", associatedWithJob())
                .add("ManagedDeviceArn", managedDeviceArn()).add("ManagedDeviceId", managedDeviceId())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "associatedWithJob":
            return Optional.ofNullable(clazz.cast(associatedWithJob()));
        case "managedDeviceArn":
            return Optional.ofNullable(clazz.cast(managedDeviceArn()));
        case "managedDeviceId":
            return Optional.ofNullable(clazz.cast(managedDeviceId()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceSummary, T> g) {
        return obj -> g.apply((DeviceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeviceSummary> {
        /**
         * <p>
         * The ID of the job used to order the device.
         * </p>
         * 
         * @param associatedWithJob
         *        The ID of the job used to order the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedWithJob(String associatedWithJob);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the device.
         * </p>
         * 
         * @param managedDeviceArn
         *        The Amazon Resource Name (ARN) of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedDeviceArn(String managedDeviceArn);

        /**
         * <p>
         * The ID of the device.
         * </p>
         * 
         * @param managedDeviceId
         *        The ID of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedDeviceId(String managedDeviceId);

        /**
         * <p>
         * Optional metadata that you assign to a resource. You can use tags to categorize a resource in different ways,
         * such as by purpose, owner, or environment.
         * </p>
         * 
         * @param tags
         *        Optional metadata that you assign to a resource. You can use tags to categorize a resource in
         *        different ways, such as by purpose, owner, or environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String associatedWithJob;

        private String managedDeviceArn;

        private String managedDeviceId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceSummary model) {
            associatedWithJob(model.associatedWithJob);
            managedDeviceArn(model.managedDeviceArn);
            managedDeviceId(model.managedDeviceId);
            tags(model.tags);
        }

        public final String getAssociatedWithJob() {
            return associatedWithJob;
        }

        public final void setAssociatedWithJob(String associatedWithJob) {
            this.associatedWithJob = associatedWithJob;
        }

        @Override
        public final Builder associatedWithJob(String associatedWithJob) {
            this.associatedWithJob = associatedWithJob;
            return this;
        }

        public final String getManagedDeviceArn() {
            return managedDeviceArn;
        }

        public final void setManagedDeviceArn(String managedDeviceArn) {
            this.managedDeviceArn = managedDeviceArn;
        }

        @Override
        public final Builder managedDeviceArn(String managedDeviceArn) {
            this.managedDeviceArn = managedDeviceArn;
            return this;
        }

        public final String getManagedDeviceId() {
            return managedDeviceId;
        }

        public final void setManagedDeviceId(String managedDeviceId) {
            this.managedDeviceId = managedDeviceId;
        }

        @Override
        public final Builder managedDeviceId(String managedDeviceId) {
            this.managedDeviceId = managedDeviceId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public DeviceSummary build() {
            return new DeviceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
