/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowdevicemanagement.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.snowdevicemanagement.model.SnowDeviceManagementResponse;
import software.amazon.awssdk.services.snowdevicemanagement.model.TaskSummary;
import software.amazon.awssdk.services.snowdevicemanagement.model.TaskSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTasksResponse
extends SnowDeviceManagementResponse
implements ToCopyableBuilder<Builder, ListTasksResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTasksResponse.getter(ListTasksResponse::nextToken)).setter(ListTasksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<TaskSummary>> TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tasks").getter(ListTasksResponse.getter(ListTasksResponse::tasks)).setter(ListTasksResponse.setter(Builder::tasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tasks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TaskSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, TASKS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("tasks", TASKS_FIELD);
        }
    });
    private final String nextToken;
    private final List<TaskSummary> tasks;

    private ListTasksResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.tasks = builder.tasks;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasTasks() {
        return this.tasks != null && !(this.tasks instanceof SdkAutoConstructList);
    }

    public final List<TaskSummary> tasks() {
        return this.tasks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTasks() ? this.tasks() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTasksResponse)) {
            return false;
        }
        ListTasksResponse other = (ListTasksResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasTasks() == other.hasTasks() && Objects.equals(this.tasks(), other.tasks());
    }

    public final String toString() {
        return ToString.builder((String)"ListTasksResponse").add("NextToken", (Object)this.nextToken()).add("Tasks", this.hasTasks() ? this.tasks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "tasks": {
                return Optional.ofNullable(clazz.cast(this.tasks()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListTasksResponse, T> g) {
        return obj -> g.apply((ListTasksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SnowDeviceManagementResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<TaskSummary> tasks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTasksResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.tasks(model.tasks);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<TaskSummary.Builder> getTasks() {
            List<TaskSummary.Builder> result = TaskSummaryListCopier.copyToBuilder(this.tasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTasks(Collection<TaskSummary.BuilderImpl> tasks) {
            this.tasks = TaskSummaryListCopier.copyFromBuilder(tasks);
        }

        @Override
        public final Builder tasks(Collection<TaskSummary> tasks) {
            this.tasks = TaskSummaryListCopier.copy(tasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(TaskSummary ... tasks) {
            this.tasks(Arrays.asList(tasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(Consumer<TaskSummary.Builder> ... tasks) {
            this.tasks(Stream.of(tasks).map(c -> (TaskSummary)((TaskSummary.Builder)TaskSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListTasksResponse build() {
            return new ListTasksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SnowDeviceManagementResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTasksResponse> {
        public Builder nextToken(String var1);

        public Builder tasks(Collection<TaskSummary> var1);

        public Builder tasks(TaskSummary ... var1);

        public Builder tasks(Consumer<TaskSummary.Builder> ... var1);
    }
}

