/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowdevicemanagement.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The physical capacity of the Amazon Web Services Snow Family device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Capacity implements SdkPojo, Serializable, ToCopyableBuilder<Capacity.Builder, Capacity> {
    private static final SdkField<Long> AVAILABLE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("available")
            .getter(getter(Capacity::available)).setter(setter(Builder::available))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("available").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Capacity::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Long> TOTAL_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("total")
            .getter(getter(Capacity::total)).setter(setter(Builder::total))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("total").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("unit")
            .getter(getter(Capacity::unit)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()).build();

    private static final SdkField<Long> USED_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("used")
            .getter(getter(Capacity::used)).setter(setter(Builder::used))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("used").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABLE_FIELD, NAME_FIELD,
            TOTAL_FIELD, UNIT_FIELD, USED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long available;

    private final String name;

    private final Long total;

    private final String unit;

    private final Long used;

    private Capacity(BuilderImpl builder) {
        this.available = builder.available;
        this.name = builder.name;
        this.total = builder.total;
        this.unit = builder.unit;
        this.used = builder.used;
    }

    /**
     * <p>
     * The amount of capacity available for use on the device.
     * </p>
     * 
     * @return The amount of capacity available for use on the device.
     */
    public final Long available() {
        return available;
    }

    /**
     * <p>
     * The name of the type of capacity, such as memory.
     * </p>
     * 
     * @return The name of the type of capacity, such as memory.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The total capacity on the device.
     * </p>
     * 
     * @return The total capacity on the device.
     */
    public final Long total() {
        return total;
    }

    /**
     * <p>
     * The unit of measure for the type of capacity.
     * </p>
     * 
     * @return The unit of measure for the type of capacity.
     */
    public final String unit() {
        return unit;
    }

    /**
     * <p>
     * The amount of capacity used on the device.
     * </p>
     * 
     * @return The amount of capacity used on the device.
     */
    public final Long used() {
        return used;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(available());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(total());
        hashCode = 31 * hashCode + Objects.hashCode(unit());
        hashCode = 31 * hashCode + Objects.hashCode(used());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Capacity)) {
            return false;
        }
        Capacity other = (Capacity) obj;
        return Objects.equals(available(), other.available()) && Objects.equals(name(), other.name())
                && Objects.equals(total(), other.total()) && Objects.equals(unit(), other.unit())
                && Objects.equals(used(), other.used());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Capacity").add("Available", available()).add("Name", name()).add("Total", total())
                .add("Unit", unit()).add("Used", used()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "available":
            return Optional.ofNullable(clazz.cast(available()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "total":
            return Optional.ofNullable(clazz.cast(total()));
        case "unit":
            return Optional.ofNullable(clazz.cast(unit()));
        case "used":
            return Optional.ofNullable(clazz.cast(used()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("available", AVAILABLE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("total", TOTAL_FIELD);
        map.put("unit", UNIT_FIELD);
        map.put("used", USED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Capacity, T> g) {
        return obj -> g.apply((Capacity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Capacity> {
        /**
         * <p>
         * The amount of capacity available for use on the device.
         * </p>
         * 
         * @param available
         *        The amount of capacity available for use on the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder available(Long available);

        /**
         * <p>
         * The name of the type of capacity, such as memory.
         * </p>
         * 
         * @param name
         *        The name of the type of capacity, such as memory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The total capacity on the device.
         * </p>
         * 
         * @param total
         *        The total capacity on the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(Long total);

        /**
         * <p>
         * The unit of measure for the type of capacity.
         * </p>
         * 
         * @param unit
         *        The unit of measure for the type of capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unit(String unit);

        /**
         * <p>
         * The amount of capacity used on the device.
         * </p>
         * 
         * @param used
         *        The amount of capacity used on the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder used(Long used);
    }

    static final class BuilderImpl implements Builder {
        private Long available;

        private String name;

        private Long total;

        private String unit;

        private Long used;

        private BuilderImpl() {
        }

        private BuilderImpl(Capacity model) {
            available(model.available);
            name(model.name);
            total(model.total);
            unit(model.unit);
            used(model.used);
        }

        public final Long getAvailable() {
            return available;
        }

        public final void setAvailable(Long available) {
            this.available = available;
        }

        @Override
        public final Builder available(Long available) {
            this.available = available;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Long getTotal() {
            return total;
        }

        public final void setTotal(Long total) {
            this.total = total;
        }

        @Override
        public final Builder total(Long total) {
            this.total = total;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final Long getUsed() {
            return used;
        }

        public final void setUsed(Long used) {
            this.used = used;
        }

        @Override
        public final Builder used(Long used) {
            this.used = used;
            return this;
        }

        @Override
        public Capacity build() {
            return new Capacity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
