/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowdevicemanagement.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The description of a block device mapping.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceBlockDeviceMapping implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceBlockDeviceMapping.Builder, InstanceBlockDeviceMapping> {
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deviceName").getter(getter(InstanceBlockDeviceMapping::deviceName)).setter(setter(Builder::deviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceName").build()).build();

    private static final SdkField<EbsInstanceBlockDevice> EBS_FIELD = SdkField
            .<EbsInstanceBlockDevice> builder(MarshallingType.SDK_POJO).memberName("ebs")
            .getter(getter(InstanceBlockDeviceMapping::ebs)).setter(setter(Builder::ebs))
            .constructor(EbsInstanceBlockDevice::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_NAME_FIELD, EBS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String deviceName;

    private final EbsInstanceBlockDevice ebs;

    private InstanceBlockDeviceMapping(BuilderImpl builder) {
        this.deviceName = builder.deviceName;
        this.ebs = builder.ebs;
    }

    /**
     * <p>
     * The block device name.
     * </p>
     * 
     * @return The block device name.
     */
    public final String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * The parameters used to automatically set up Amazon Elastic Block Store (Amazon EBS) volumes when the instance is
     * launched.
     * </p>
     * 
     * @return The parameters used to automatically set up Amazon Elastic Block Store (Amazon EBS) volumes when the
     *         instance is launched.
     */
    public final EbsInstanceBlockDevice ebs() {
        return ebs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(ebs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceBlockDeviceMapping)) {
            return false;
        }
        InstanceBlockDeviceMapping other = (InstanceBlockDeviceMapping) obj;
        return Objects.equals(deviceName(), other.deviceName()) && Objects.equals(ebs(), other.ebs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceBlockDeviceMapping").add("DeviceName", deviceName()).add("Ebs", ebs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        case "ebs":
            return Optional.ofNullable(clazz.cast(ebs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("deviceName", DEVICE_NAME_FIELD);
        map.put("ebs", EBS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceBlockDeviceMapping, T> g) {
        return obj -> g.apply((InstanceBlockDeviceMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceBlockDeviceMapping> {
        /**
         * <p>
         * The block device name.
         * </p>
         * 
         * @param deviceName
         *        The block device name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * The parameters used to automatically set up Amazon Elastic Block Store (Amazon EBS) volumes when the instance
         * is launched.
         * </p>
         * 
         * @param ebs
         *        The parameters used to automatically set up Amazon Elastic Block Store (Amazon EBS) volumes when the
         *        instance is launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebs(EbsInstanceBlockDevice ebs);

        /**
         * <p>
         * The parameters used to automatically set up Amazon Elastic Block Store (Amazon EBS) volumes when the instance
         * is launched.
         * </p>
         * This is a convenience method that creates an instance of the {@link EbsInstanceBlockDevice.Builder} avoiding
         * the need to create one manually via {@link EbsInstanceBlockDevice#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EbsInstanceBlockDevice.Builder#build()} is called immediately and
         * its result is passed to {@link #ebs(EbsInstanceBlockDevice)}.
         * 
         * @param ebs
         *        a consumer that will call methods on {@link EbsInstanceBlockDevice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ebs(EbsInstanceBlockDevice)
         */
        default Builder ebs(Consumer<EbsInstanceBlockDevice.Builder> ebs) {
            return ebs(EbsInstanceBlockDevice.builder().applyMutation(ebs).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String deviceName;

        private EbsInstanceBlockDevice ebs;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceBlockDeviceMapping model) {
            deviceName(model.deviceName);
            ebs(model.ebs);
        }

        public final String getDeviceName() {
            return deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final EbsInstanceBlockDevice.Builder getEbs() {
            return ebs != null ? ebs.toBuilder() : null;
        }

        public final void setEbs(EbsInstanceBlockDevice.BuilderImpl ebs) {
            this.ebs = ebs != null ? ebs.build() : null;
        }

        @Override
        public final Builder ebs(EbsInstanceBlockDevice ebs) {
            this.ebs = ebs;
            return this;
        }

        @Override
        public InstanceBlockDeviceMapping build() {
            return new InstanceBlockDeviceMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
