/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowdevicemanagement.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details about the instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceSummary implements SdkPojo, Serializable, ToCopyableBuilder<InstanceSummary.Builder, InstanceSummary> {
    private static final SdkField<Instance> INSTANCE_FIELD = SdkField.<Instance> builder(MarshallingType.SDK_POJO)
            .memberName("instance").getter(getter(InstanceSummary::instance)).setter(setter(Builder::instance))
            .constructor(Instance::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instance").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt").getter(getter(InstanceSummary::lastUpdatedAt)).setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_FIELD,
            LAST_UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instance instance;

    private final Instant lastUpdatedAt;

    private InstanceSummary(BuilderImpl builder) {
        this.instance = builder.instance;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    /**
     * <p>
     * A structure containing details about the instance.
     * </p>
     * 
     * @return A structure containing details about the instance.
     */
    public final Instance instance() {
        return instance;
    }

    /**
     * <p>
     * When the instance summary was last updated.
     * </p>
     * 
     * @return When the instance summary was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instance());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceSummary)) {
            return false;
        }
        InstanceSummary other = (InstanceSummary) obj;
        return Objects.equals(instance(), other.instance()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceSummary").add("Instance", instance()).add("LastUpdatedAt", lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instance":
            return Optional.ofNullable(clazz.cast(instance()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("instance", INSTANCE_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceSummary, T> g) {
        return obj -> g.apply((InstanceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceSummary> {
        /**
         * <p>
         * A structure containing details about the instance.
         * </p>
         * 
         * @param instance
         *        A structure containing details about the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instance(Instance instance);

        /**
         * <p>
         * A structure containing details about the instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link Instance.Builder} avoiding the need to
         * create one manually via {@link Instance#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Instance.Builder#build()} is called immediately and its result is
         * passed to {@link #instance(Instance)}.
         * 
         * @param instance
         *        a consumer that will call methods on {@link Instance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instance(Instance)
         */
        default Builder instance(Consumer<Instance.Builder> instance) {
            return instance(Instance.builder().applyMutation(instance).build());
        }

        /**
         * <p>
         * When the instance summary was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        When the instance summary was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);
    }

    static final class BuilderImpl implements Builder {
        private Instance instance;

        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceSummary model) {
            instance(model.instance);
            lastUpdatedAt(model.lastUpdatedAt);
        }

        public final Instance.Builder getInstance() {
            return instance != null ? instance.toBuilder() : null;
        }

        public final void setInstance(Instance.BuilderImpl instance) {
            this.instance = instance != null ? instance.build() : null;
        }

        @Override
        public final Builder instance(Instance instance) {
            this.instance = instance;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        @Override
        public InstanceSummary build() {
            return new InstanceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
