/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowdevicemanagement.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.snowdevicemanagement.model.CpuOptions;
import software.amazon.awssdk.services.snowdevicemanagement.model.InstanceBlockDeviceMapping;
import software.amazon.awssdk.services.snowdevicemanagement.model.InstanceBlockDeviceMappingListCopier;
import software.amazon.awssdk.services.snowdevicemanagement.model.InstanceState;
import software.amazon.awssdk.services.snowdevicemanagement.model.SecurityGroupIdentifier;
import software.amazon.awssdk.services.snowdevicemanagement.model.SecurityGroupIdentifierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Instance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Instance> {
    private static final SdkField<Integer> AMI_LAUNCH_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("amiLaunchIndex").getter(Instance.getter(Instance::amiLaunchIndex)).setter(Instance.setter(Builder::amiLaunchIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amiLaunchIndex").build()}).build();
    private static final SdkField<List<InstanceBlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("blockDeviceMappings").getter(Instance.getter(Instance::blockDeviceMappings)).setter(Instance.setter(Builder::blockDeviceMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockDeviceMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceBlockDeviceMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CpuOptions> CPU_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cpuOptions").getter(Instance.getter(Instance::cpuOptions)).setter(Instance.setter(Builder::cpuOptions)).constructor(CpuOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuOptions").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Instance.getter(Instance::createdAt)).setter(Instance.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageId").getter(Instance.getter(Instance::imageId)).setter(Instance.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageId").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceId").getter(Instance.getter(Instance::instanceId)).setter(Instance.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceId").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceType").getter(Instance.getter(Instance::instanceType)).setter(Instance.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()}).build();
    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("privateIpAddress").getter(Instance.getter(Instance::privateIpAddress)).setter(Instance.setter(Builder::privateIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateIpAddress").build()}).build();
    private static final SdkField<String> PUBLIC_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("publicIpAddress").getter(Instance.getter(Instance::publicIpAddress)).setter(Instance.setter(Builder::publicIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicIpAddress").build()}).build();
    private static final SdkField<String> ROOT_DEVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rootDeviceName").getter(Instance.getter(Instance::rootDeviceName)).setter(Instance.setter(Builder::rootDeviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rootDeviceName").build()}).build();
    private static final SdkField<List<SecurityGroupIdentifier>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("securityGroups").getter(Instance.getter(Instance::securityGroups)).setter(Instance.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecurityGroupIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<InstanceState> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("state").getter(Instance.getter(Instance::state)).setter(Instance.setter(Builder::state)).constructor(InstanceState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(Instance.getter(Instance::updatedAt)).setter(Instance.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMI_LAUNCH_INDEX_FIELD, BLOCK_DEVICE_MAPPINGS_FIELD, CPU_OPTIONS_FIELD, CREATED_AT_FIELD, IMAGE_ID_FIELD, INSTANCE_ID_FIELD, INSTANCE_TYPE_FIELD, PRIVATE_IP_ADDRESS_FIELD, PUBLIC_IP_ADDRESS_FIELD, ROOT_DEVICE_NAME_FIELD, SECURITY_GROUPS_FIELD, STATE_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Instance.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer amiLaunchIndex;
    private final List<InstanceBlockDeviceMapping> blockDeviceMappings;
    private final CpuOptions cpuOptions;
    private final Instant createdAt;
    private final String imageId;
    private final String instanceId;
    private final String instanceType;
    private final String privateIpAddress;
    private final String publicIpAddress;
    private final String rootDeviceName;
    private final List<SecurityGroupIdentifier> securityGroups;
    private final InstanceState state;
    private final Instant updatedAt;

    private Instance(BuilderImpl builder) {
        this.amiLaunchIndex = builder.amiLaunchIndex;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.cpuOptions = builder.cpuOptions;
        this.createdAt = builder.createdAt;
        this.imageId = builder.imageId;
        this.instanceId = builder.instanceId;
        this.instanceType = builder.instanceType;
        this.privateIpAddress = builder.privateIpAddress;
        this.publicIpAddress = builder.publicIpAddress;
        this.rootDeviceName = builder.rootDeviceName;
        this.securityGroups = builder.securityGroups;
        this.state = builder.state;
        this.updatedAt = builder.updatedAt;
    }

    public final Integer amiLaunchIndex() {
        return this.amiLaunchIndex;
    }

    public final boolean hasBlockDeviceMappings() {
        return this.blockDeviceMappings != null && !(this.blockDeviceMappings instanceof SdkAutoConstructList);
    }

    public final List<InstanceBlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public final CpuOptions cpuOptions() {
        return this.cpuOptions;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final String privateIpAddress() {
        return this.privateIpAddress;
    }

    public final String publicIpAddress() {
        return this.publicIpAddress;
    }

    public final String rootDeviceName() {
        return this.rootDeviceName;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<SecurityGroupIdentifier> securityGroups() {
        return this.securityGroups;
    }

    public final InstanceState state() {
        return this.state;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amiLaunchIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlockDeviceMappings() ? this.blockDeviceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cpuOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootDeviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance)obj;
        return Objects.equals(this.amiLaunchIndex(), other.amiLaunchIndex()) && this.hasBlockDeviceMappings() == other.hasBlockDeviceMappings() && Objects.equals(this.blockDeviceMappings(), other.blockDeviceMappings()) && Objects.equals(this.cpuOptions(), other.cpuOptions()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.privateIpAddress(), other.privateIpAddress()) && Objects.equals(this.publicIpAddress(), other.publicIpAddress()) && Objects.equals(this.rootDeviceName(), other.rootDeviceName()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"Instance").add("AmiLaunchIndex", (Object)this.amiLaunchIndex()).add("BlockDeviceMappings", this.hasBlockDeviceMappings() ? this.blockDeviceMappings() : null).add("CpuOptions", (Object)this.cpuOptions()).add("CreatedAt", (Object)this.createdAt()).add("ImageId", (Object)this.imageId()).add("InstanceId", (Object)this.instanceId()).add("InstanceType", (Object)this.instanceType()).add("PrivateIpAddress", (Object)this.privateIpAddress()).add("PublicIpAddress", (Object)this.publicIpAddress()).add("RootDeviceName", (Object)this.rootDeviceName()).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).add("State", (Object)this.state()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "amiLaunchIndex": {
                return Optional.ofNullable(clazz.cast(this.amiLaunchIndex()));
            }
            case "blockDeviceMappings": {
                return Optional.ofNullable(clazz.cast(this.blockDeviceMappings()));
            }
            case "cpuOptions": {
                return Optional.ofNullable(clazz.cast(this.cpuOptions()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "imageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "instanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "instanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "privateIpAddress": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddress()));
            }
            case "publicIpAddress": {
                return Optional.ofNullable(clazz.cast(this.publicIpAddress()));
            }
            case "rootDeviceName": {
                return Optional.ofNullable(clazz.cast(this.rootDeviceName()));
            }
            case "securityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("amiLaunchIndex", AMI_LAUNCH_INDEX_FIELD);
        map.put("blockDeviceMappings", BLOCK_DEVICE_MAPPINGS_FIELD);
        map.put("cpuOptions", CPU_OPTIONS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("imageId", IMAGE_ID_FIELD);
        map.put("instanceId", INSTANCE_ID_FIELD);
        map.put("instanceType", INSTANCE_TYPE_FIELD);
        map.put("privateIpAddress", PRIVATE_IP_ADDRESS_FIELD);
        map.put("publicIpAddress", PUBLIC_IP_ADDRESS_FIELD);
        map.put("rootDeviceName", ROOT_DEVICE_NAME_FIELD);
        map.put("securityGroups", SECURITY_GROUPS_FIELD);
        map.put("state", STATE_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Instance, T> g) {
        return obj -> g.apply((Instance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer amiLaunchIndex;
        private List<InstanceBlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();
        private CpuOptions cpuOptions;
        private Instant createdAt;
        private String imageId;
        private String instanceId;
        private String instanceType;
        private String privateIpAddress;
        private String publicIpAddress;
        private String rootDeviceName;
        private List<SecurityGroupIdentifier> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private InstanceState state;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Instance model) {
            this.amiLaunchIndex(model.amiLaunchIndex);
            this.blockDeviceMappings(model.blockDeviceMappings);
            this.cpuOptions(model.cpuOptions);
            this.createdAt(model.createdAt);
            this.imageId(model.imageId);
            this.instanceId(model.instanceId);
            this.instanceType(model.instanceType);
            this.privateIpAddress(model.privateIpAddress);
            this.publicIpAddress(model.publicIpAddress);
            this.rootDeviceName(model.rootDeviceName);
            this.securityGroups(model.securityGroups);
            this.state(model.state);
            this.updatedAt(model.updatedAt);
        }

        public final Integer getAmiLaunchIndex() {
            return this.amiLaunchIndex;
        }

        public final void setAmiLaunchIndex(Integer amiLaunchIndex) {
            this.amiLaunchIndex = amiLaunchIndex;
        }

        @Override
        public final Builder amiLaunchIndex(Integer amiLaunchIndex) {
            this.amiLaunchIndex = amiLaunchIndex;
            return this;
        }

        public final List<InstanceBlockDeviceMapping.Builder> getBlockDeviceMappings() {
            List<InstanceBlockDeviceMapping.Builder> result = InstanceBlockDeviceMappingListCopier.copyToBuilder(this.blockDeviceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockDeviceMappings(Collection<InstanceBlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingListCopier.copyFromBuilder(blockDeviceMappings);
        }

        @Override
        public final Builder blockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(InstanceBlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<InstanceBlockDeviceMapping.Builder> ... blockDeviceMappings) {
            this.blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> (InstanceBlockDeviceMapping)((InstanceBlockDeviceMapping.Builder)InstanceBlockDeviceMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final CpuOptions.Builder getCpuOptions() {
            return this.cpuOptions != null ? this.cpuOptions.toBuilder() : null;
        }

        public final void setCpuOptions(CpuOptions.BuilderImpl cpuOptions) {
            this.cpuOptions = cpuOptions != null ? cpuOptions.build() : null;
        }

        @Override
        public final Builder cpuOptions(CpuOptions cpuOptions) {
            this.cpuOptions = cpuOptions;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final String getPublicIpAddress() {
            return this.publicIpAddress;
        }

        public final void setPublicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
        }

        @Override
        public final Builder publicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
            return this;
        }

        public final String getRootDeviceName() {
            return this.rootDeviceName;
        }

        public final void setRootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
        }

        @Override
        public final Builder rootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
            return this;
        }

        public final List<SecurityGroupIdentifier.Builder> getSecurityGroups() {
            List<SecurityGroupIdentifier.Builder> result = SecurityGroupIdentifierListCopier.copyToBuilder(this.securityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityGroups(Collection<SecurityGroupIdentifier.BuilderImpl> securityGroups) {
            this.securityGroups = SecurityGroupIdentifierListCopier.copyFromBuilder(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<SecurityGroupIdentifier> securityGroups) {
            this.securityGroups = SecurityGroupIdentifierListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(SecurityGroupIdentifier ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(Consumer<SecurityGroupIdentifier.Builder> ... securityGroups) {
            this.securityGroups(Stream.of(securityGroups).map(c -> (SecurityGroupIdentifier)((SecurityGroupIdentifier.Builder)SecurityGroupIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final InstanceState.Builder getState() {
            return this.state != null ? this.state.toBuilder() : null;
        }

        public final void setState(InstanceState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(InstanceState state) {
            this.state = state;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Instance build() {
            return new Instance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Instance> {
        public Builder amiLaunchIndex(Integer var1);

        public Builder blockDeviceMappings(Collection<InstanceBlockDeviceMapping> var1);

        public Builder blockDeviceMappings(InstanceBlockDeviceMapping ... var1);

        public Builder blockDeviceMappings(Consumer<InstanceBlockDeviceMapping.Builder> ... var1);

        public Builder cpuOptions(CpuOptions var1);

        default public Builder cpuOptions(Consumer<CpuOptions.Builder> cpuOptions) {
            return this.cpuOptions((CpuOptions)((CpuOptions.Builder)CpuOptions.builder().applyMutation(cpuOptions)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder imageId(String var1);

        public Builder instanceId(String var1);

        public Builder instanceType(String var1);

        public Builder privateIpAddress(String var1);

        public Builder publicIpAddress(String var1);

        public Builder rootDeviceName(String var1);

        public Builder securityGroups(Collection<SecurityGroupIdentifier> var1);

        public Builder securityGroups(SecurityGroupIdentifier ... var1);

        public Builder securityGroups(Consumer<SecurityGroupIdentifier.Builder> ... var1);

        public Builder state(InstanceState var1);

        default public Builder state(Consumer<InstanceState.Builder> state) {
            return this.state((InstanceState)((InstanceState.Builder)InstanceState.builder().applyMutation(state)).build());
        }

        public Builder updatedAt(Instant var1);
    }
}

