/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowdevicemanagement.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.snowdevicemanagement.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeviceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeviceSummary> {
    private static final SdkField<String> ASSOCIATED_WITH_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("associatedWithJob").getter(DeviceSummary.getter(DeviceSummary::associatedWithJob)).setter(DeviceSummary.setter(Builder::associatedWithJob)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedWithJob").build()}).build();
    private static final SdkField<String> MANAGED_DEVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("managedDeviceArn").getter(DeviceSummary.getter(DeviceSummary::managedDeviceArn)).setter(DeviceSummary.setter(Builder::managedDeviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedDeviceArn").build()}).build();
    private static final SdkField<String> MANAGED_DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("managedDeviceId").getter(DeviceSummary.getter(DeviceSummary::managedDeviceId)).setter(DeviceSummary.setter(Builder::managedDeviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedDeviceId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(DeviceSummary.getter(DeviceSummary::tags)).setter(DeviceSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATED_WITH_JOB_FIELD, MANAGED_DEVICE_ARN_FIELD, MANAGED_DEVICE_ID_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeviceSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String associatedWithJob;
    private final String managedDeviceArn;
    private final String managedDeviceId;
    private final Map<String, String> tags;

    private DeviceSummary(BuilderImpl builder) {
        this.associatedWithJob = builder.associatedWithJob;
        this.managedDeviceArn = builder.managedDeviceArn;
        this.managedDeviceId = builder.managedDeviceId;
        this.tags = builder.tags;
    }

    public final String associatedWithJob() {
        return this.associatedWithJob;
    }

    public final String managedDeviceArn() {
        return this.managedDeviceArn;
    }

    public final String managedDeviceId() {
        return this.managedDeviceId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedWithJob());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedDeviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedDeviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceSummary)) {
            return false;
        }
        DeviceSummary other = (DeviceSummary)obj;
        return Objects.equals(this.associatedWithJob(), other.associatedWithJob()) && Objects.equals(this.managedDeviceArn(), other.managedDeviceArn()) && Objects.equals(this.managedDeviceId(), other.managedDeviceId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"DeviceSummary").add("AssociatedWithJob", (Object)this.associatedWithJob()).add("ManagedDeviceArn", (Object)this.managedDeviceArn()).add("ManagedDeviceId", (Object)this.managedDeviceId()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "associatedWithJob": {
                return Optional.ofNullable(clazz.cast(this.associatedWithJob()));
            }
            case "managedDeviceArn": {
                return Optional.ofNullable(clazz.cast(this.managedDeviceArn()));
            }
            case "managedDeviceId": {
                return Optional.ofNullable(clazz.cast(this.managedDeviceId()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("associatedWithJob", ASSOCIATED_WITH_JOB_FIELD);
        map.put("managedDeviceArn", MANAGED_DEVICE_ARN_FIELD);
        map.put("managedDeviceId", MANAGED_DEVICE_ID_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeviceSummary, T> g) {
        return obj -> g.apply((DeviceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String associatedWithJob;
        private String managedDeviceArn;
        private String managedDeviceId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceSummary model) {
            this.associatedWithJob(model.associatedWithJob);
            this.managedDeviceArn(model.managedDeviceArn);
            this.managedDeviceId(model.managedDeviceId);
            this.tags(model.tags);
        }

        public final String getAssociatedWithJob() {
            return this.associatedWithJob;
        }

        public final void setAssociatedWithJob(String associatedWithJob) {
            this.associatedWithJob = associatedWithJob;
        }

        @Override
        public final Builder associatedWithJob(String associatedWithJob) {
            this.associatedWithJob = associatedWithJob;
            return this;
        }

        public final String getManagedDeviceArn() {
            return this.managedDeviceArn;
        }

        public final void setManagedDeviceArn(String managedDeviceArn) {
            this.managedDeviceArn = managedDeviceArn;
        }

        @Override
        public final Builder managedDeviceArn(String managedDeviceArn) {
            this.managedDeviceArn = managedDeviceArn;
            return this;
        }

        public final String getManagedDeviceId() {
            return this.managedDeviceId;
        }

        public final void setManagedDeviceId(String managedDeviceId) {
            this.managedDeviceId = managedDeviceId;
        }

        @Override
        public final Builder managedDeviceId(String managedDeviceId) {
            this.managedDeviceId = managedDeviceId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public DeviceSummary build() {
            return new DeviceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeviceSummary> {
        public Builder associatedWithJob(String var1);

        public Builder managedDeviceArn(String var1);

        public Builder managedDeviceId(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

