/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class AddPermissionRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<AddPermissionRequest.Builder, AddPermissionRequest> {
    private final String topicArn;

    private final String label;

    private final List<String> awsAccountIds;

    private final List<String> actionNames;

    private AddPermissionRequest(BuilderImpl builder) {
        this.topicArn = builder.topicArn;
        this.label = builder.label;
        this.awsAccountIds = builder.awsAccountIds;
        this.actionNames = builder.actionNames;
    }

    /**
     * <p>
     * The ARN of the topic whose access control policy you wish to modify.
     * </p>
     * 
     * @return The ARN of the topic whose access control policy you wish to modify.
     */
    public String topicArn() {
        return topicArn;
    }

    /**
     * <p>
     * A unique identifier for the new policy statement.
     * </p>
     * 
     * @return A unique identifier for the new policy statement.
     */
    public String label() {
        return label;
    }

    /**
     * <p>
     * The AWS account IDs of the users (principals) who will be given access to the specified actions. The users must
     * have AWS accounts, but do not need to be signed up for this service.
     * </p>
     * 
     * @return The AWS account IDs of the users (principals) who will be given access to the specified actions. The
     *         users must have AWS accounts, but do not need to be signed up for this service.
     */
    public List<String> awsAccountIds() {
        return awsAccountIds;
    }

    /**
     * <p>
     * The action you want to allow for the specified principal(s).
     * </p>
     * <p>
     * Valid values: any Amazon SNS action name.
     * </p>
     * 
     * @return The action you want to allow for the specified principal(s).</p>
     *         <p>
     *         Valid values: any Amazon SNS action name.
     */
    public List<String> actionNames() {
        return actionNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((topicArn() == null) ? 0 : topicArn().hashCode());
        hashCode = 31 * hashCode + ((label() == null) ? 0 : label().hashCode());
        hashCode = 31 * hashCode + ((awsAccountIds() == null) ? 0 : awsAccountIds().hashCode());
        hashCode = 31 * hashCode + ((actionNames() == null) ? 0 : actionNames().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddPermissionRequest)) {
            return false;
        }
        AddPermissionRequest other = (AddPermissionRequest) obj;
        if (other.topicArn() == null ^ this.topicArn() == null) {
            return false;
        }
        if (other.topicArn() != null && !other.topicArn().equals(this.topicArn())) {
            return false;
        }
        if (other.label() == null ^ this.label() == null) {
            return false;
        }
        if (other.label() != null && !other.label().equals(this.label())) {
            return false;
        }
        if (other.awsAccountIds() == null ^ this.awsAccountIds() == null) {
            return false;
        }
        if (other.awsAccountIds() != null && !other.awsAccountIds().equals(this.awsAccountIds())) {
            return false;
        }
        if (other.actionNames() == null ^ this.actionNames() == null) {
            return false;
        }
        if (other.actionNames() != null && !other.actionNames().equals(this.actionNames())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (topicArn() != null) {
            sb.append("TopicArn: ").append(topicArn()).append(",");
        }
        if (label() != null) {
            sb.append("Label: ").append(label()).append(",");
        }
        if (awsAccountIds() != null) {
            sb.append("AWSAccountIds: ").append(awsAccountIds()).append(",");
        }
        if (actionNames() != null) {
            sb.append("ActionNames: ").append(actionNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, AddPermissionRequest> {
        /**
         * <p>
         * The ARN of the topic whose access control policy you wish to modify.
         * </p>
         * 
         * @param topicArn
         *        The ARN of the topic whose access control policy you wish to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicArn(String topicArn);

        /**
         * <p>
         * A unique identifier for the new policy statement.
         * </p>
         * 
         * @param label
         *        A unique identifier for the new policy statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(String label);

        /**
         * <p>
         * The AWS account IDs of the users (principals) who will be given access to the specified actions. The users
         * must have AWS accounts, but do not need to be signed up for this service.
         * </p>
         * 
         * @param awsAccountIds
         *        The AWS account IDs of the users (principals) who will be given access to the specified actions. The
         *        users must have AWS accounts, but do not need to be signed up for this service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountIds(Collection<String> awsAccountIds);

        /**
         * <p>
         * The AWS account IDs of the users (principals) who will be given access to the specified actions. The users
         * must have AWS accounts, but do not need to be signed up for this service.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setAWSAccountIds(java.util.Collection)} or {@link #withAWSAccountIds(java.util.Collection)} if you
         * want to override the existing values.
         * </p>
         * 
         * @param awsAccountIds
         *        The AWS account IDs of the users (principals) who will be given access to the specified actions. The
         *        users must have AWS accounts, but do not need to be signed up for this service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountIds(String... awsAccountIds);

        /**
         * <p>
         * The action you want to allow for the specified principal(s).
         * </p>
         * <p>
         * Valid values: any Amazon SNS action name.
         * </p>
         * 
         * @param actionNames
         *        The action you want to allow for the specified principal(s).</p>
         *        <p>
         *        Valid values: any Amazon SNS action name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionNames(Collection<String> actionNames);

        /**
         * <p>
         * The action you want to allow for the specified principal(s).
         * </p>
         * <p>
         * Valid values: any Amazon SNS action name.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setActionNames(java.util.Collection)} or {@link #withActionNames(java.util.Collection)} if you want
         * to override the existing values.
         * </p>
         * 
         * @param actionNames
         *        The action you want to allow for the specified principal(s).</p>
         *        <p>
         *        Valid values: any Amazon SNS action name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionNames(String... actionNames);
    }

    private static final class BuilderImpl implements Builder {
        private String topicArn;

        private String label;

        private List<String> awsAccountIds = new SdkInternalList<>();

        private List<String> actionNames = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(AddPermissionRequest model) {
            setTopicArn(model.topicArn);
            setLabel(model.label);
            setAWSAccountIds(model.awsAccountIds);
            setActionNames(model.actionNames);
        }

        public final String getTopicArn() {
            return topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final String getLabel() {
            return label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        public final Collection<String> getAWSAccountIds() {
            return awsAccountIds;
        }

        @Override
        public final Builder awsAccountIds(Collection<String> awsAccountIds) {
            this.awsAccountIds = DelegatesListCopier.copy(awsAccountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsAccountIds(String... awsAccountIds) {
            if (this.awsAccountIds == null) {
                this.awsAccountIds = new SdkInternalList<>(awsAccountIds.length);
            }
            for (String e : awsAccountIds) {
                this.awsAccountIds.add(e);
            }
            return this;
        }

        public final void setAWSAccountIds(Collection<String> awsAccountIds) {
            this.awsAccountIds = DelegatesListCopier.copy(awsAccountIds);
        }

        @SafeVarargs
        public final void setAWSAccountIds(String... awsAccountIds) {
            if (this.awsAccountIds == null) {
                this.awsAccountIds = new SdkInternalList<>(awsAccountIds.length);
            }
            for (String e : awsAccountIds) {
                this.awsAccountIds.add(e);
            }
        }

        public final Collection<String> getActionNames() {
            return actionNames;
        }

        @Override
        public final Builder actionNames(Collection<String> actionNames) {
            this.actionNames = ActionsListCopier.copy(actionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionNames(String... actionNames) {
            if (this.actionNames == null) {
                this.actionNames = new SdkInternalList<>(actionNames.length);
            }
            for (String e : actionNames) {
                this.actionNames.add(e);
            }
            return this;
        }

        public final void setActionNames(Collection<String> actionNames) {
            this.actionNames = ActionsListCopier.copy(actionNames);
        }

        @SafeVarargs
        public final void setActionNames(String... actionNames) {
            if (this.actionNames == null) {
                this.actionNames = new SdkInternalList<>(actionNames.length);
            }
            for (String e : actionNames) {
                this.actionNames.add(e);
            }
        }

        @Override
        public AddPermissionRequest build() {
            return new AddPermissionRequest(this);
        }
    }
}
