/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for GetEndpointAttributes action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetEndpointAttributesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetEndpointAttributesRequest.Builder, GetEndpointAttributesRequest> {
    private final String endpointArn;

    private GetEndpointAttributesRequest(BuilderImpl builder) {
        this.endpointArn = builder.endpointArn;
    }

    /**
     * <p>
     * EndpointArn for GetEndpointAttributes input.
     * </p>
     * 
     * @return EndpointArn for GetEndpointAttributes input.
     */
    public String endpointArn() {
        return endpointArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((endpointArn() == null) ? 0 : endpointArn().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEndpointAttributesRequest)) {
            return false;
        }
        GetEndpointAttributesRequest other = (GetEndpointAttributesRequest) obj;
        if (other.endpointArn() == null ^ this.endpointArn() == null) {
            return false;
        }
        if (other.endpointArn() != null && !other.endpointArn().equals(this.endpointArn())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (endpointArn() != null) {
            sb.append("EndpointArn: ").append(endpointArn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetEndpointAttributesRequest> {
        /**
         * <p>
         * EndpointArn for GetEndpointAttributes input.
         * </p>
         * 
         * @param endpointArn
         *        EndpointArn for GetEndpointAttributes input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointArn(String endpointArn);
    }

    private static final class BuilderImpl implements Builder {
        private String endpointArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEndpointAttributesRequest model) {
            setEndpointArn(model.endpointArn);
        }

        public final String getEndpointArn() {
            return endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        @Override
        public GetEndpointAttributesRequest build() {
            return new GetEndpointAttributesRequest(this);
        }
    }
}
