/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalMap;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Response for GetPlatformApplicationAttributes action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetPlatformApplicationAttributesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetPlatformApplicationAttributesResponse.Builder, GetPlatformApplicationAttributesResponse> {
    private final Map<String, String> attributes;

    private GetPlatformApplicationAttributesResponse(BuilderImpl builder) {
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * Attributes include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>EventEndpointCreated</code> -- Topic ARN to which EndpointCreated event notifications should be sent.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EventEndpointDeleted</code> -- Topic ARN to which EndpointDeleted event notifications should be sent.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EventEndpointUpdated</code> -- Topic ARN to which EndpointUpdate event notifications should be sent.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EventDeliveryFailure</code> -- Topic ARN to which DeliveryFailure event notifications should be sent upon
     * Direct Publish delivery failure (permanent) to one of the application's endpoints.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Attributes include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>EventEndpointCreated</code> -- Topic ARN to which EndpointCreated event notifications should be
     *         sent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EventEndpointDeleted</code> -- Topic ARN to which EndpointDeleted event notifications should be
     *         sent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EventEndpointUpdated</code> -- Topic ARN to which EndpointUpdate event notifications should be
     *         sent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EventDeliveryFailure</code> -- Topic ARN to which DeliveryFailure event notifications should be
     *         sent upon Direct Publish delivery failure (permanent) to one of the application's endpoints.
     *         </p>
     *         </li>
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((attributes() == null) ? 0 : attributes().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPlatformApplicationAttributesResponse)) {
            return false;
        }
        GetPlatformApplicationAttributesResponse other = (GetPlatformApplicationAttributesResponse) obj;
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        if (other.attributes() != null && !other.attributes().equals(this.attributes())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (attributes() != null) {
            sb.append("Attributes: ").append(attributes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetPlatformApplicationAttributesResponse> {
        /**
         * <p>
         * Attributes include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>EventEndpointCreated</code> -- Topic ARN to which EndpointCreated event notifications should be sent.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EventEndpointDeleted</code> -- Topic ARN to which EndpointDeleted event notifications should be sent.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EventEndpointUpdated</code> -- Topic ARN to which EndpointUpdate event notifications should be sent.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EventDeliveryFailure</code> -- Topic ARN to which DeliveryFailure event notifications should be sent
         * upon Direct Publish delivery failure (permanent) to one of the application's endpoints.
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributes
         *        Attributes include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>EventEndpointCreated</code> -- Topic ARN to which EndpointCreated event notifications should be
         *        sent.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EventEndpointDeleted</code> -- Topic ARN to which EndpointDeleted event notifications should be
         *        sent.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EventEndpointUpdated</code> -- Topic ARN to which EndpointUpdate event notifications should be
         *        sent.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EventDeliveryFailure</code> -- Topic ARN to which DeliveryFailure event notifications should be
         *        sent upon Direct Publish delivery failure (permanent) to one of the application's endpoints.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);
    }

    private static final class BuilderImpl implements Builder {
        private Map<String, String> attributes = new SdkInternalMap<>();

        private BuilderImpl() {
        }

        private BuilderImpl(GetPlatformApplicationAttributesResponse model) {
            setAttributes(model.attributes);
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
        }

        @Override
        public GetPlatformApplicationAttributesResponse build() {
            return new GetPlatformApplicationAttributesResponse(this);
        }
    }
}
