/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Response for ListEndpointsByPlatformApplication action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListEndpointsByPlatformApplicationResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListEndpointsByPlatformApplicationResponse.Builder, ListEndpointsByPlatformApplicationResponse> {
    private final List<Endpoint> endpoints;

    private final String nextToken;

    private ListEndpointsByPlatformApplicationResponse(BuilderImpl builder) {
        this.endpoints = builder.endpoints;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Endpoints returned for ListEndpointsByPlatformApplication action.
     * </p>
     * 
     * @return Endpoints returned for ListEndpointsByPlatformApplication action.
     */
    public List<Endpoint> endpoints() {
        return endpoints;
    }

    /**
     * <p>
     * NextToken string is returned when calling ListEndpointsByPlatformApplication action if additional records are
     * available after the first page results.
     * </p>
     * 
     * @return NextToken string is returned when calling ListEndpointsByPlatformApplication action if additional records
     *         are available after the first page results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((endpoints() == null) ? 0 : endpoints().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEndpointsByPlatformApplicationResponse)) {
            return false;
        }
        ListEndpointsByPlatformApplicationResponse other = (ListEndpointsByPlatformApplicationResponse) obj;
        if (other.endpoints() == null ^ this.endpoints() == null) {
            return false;
        }
        if (other.endpoints() != null && !other.endpoints().equals(this.endpoints())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (endpoints() != null) {
            sb.append("Endpoints: ").append(endpoints()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListEndpointsByPlatformApplicationResponse> {
        /**
         * <p>
         * Endpoints returned for ListEndpointsByPlatformApplication action.
         * </p>
         * 
         * @param endpoints
         *        Endpoints returned for ListEndpointsByPlatformApplication action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(Collection<Endpoint> endpoints);

        /**
         * <p>
         * Endpoints returned for ListEndpointsByPlatformApplication action.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setEndpoints(java.util.Collection)} or {@link #withEndpoints(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param endpoints
         *        Endpoints returned for ListEndpointsByPlatformApplication action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(Endpoint... endpoints);

        /**
         * <p>
         * NextToken string is returned when calling ListEndpointsByPlatformApplication action if additional records are
         * available after the first page results.
         * </p>
         * 
         * @param nextToken
         *        NextToken string is returned when calling ListEndpointsByPlatformApplication action if additional
         *        records are available after the first page results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<Endpoint> endpoints = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEndpointsByPlatformApplicationResponse model) {
            setEndpoints(model.endpoints);
            setNextToken(model.nextToken);
        }

        public final Collection<Endpoint> getEndpoints() {
            return endpoints;
        }

        @Override
        public final Builder endpoints(Collection<Endpoint> endpoints) {
            this.endpoints = ListOfEndpointsCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Endpoint... endpoints) {
            if (this.endpoints == null) {
                this.endpoints = new SdkInternalList<>(endpoints.length);
            }
            for (Endpoint e : endpoints) {
                this.endpoints.add(e);
            }
            return this;
        }

        public final void setEndpoints(Collection<Endpoint> endpoints) {
            this.endpoints = ListOfEndpointsCopier.copy(endpoints);
        }

        @SafeVarargs
        public final void setEndpoints(Endpoint... endpoints) {
            if (this.endpoints == null) {
                this.endpoints = new SdkInternalList<>(endpoints.length);
            }
            for (Endpoint e : endpoints) {
                this.endpoints.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListEndpointsByPlatformApplicationResponse build() {
            return new ListEndpointsByPlatformApplicationResponse(this);
        }
    }
}
