/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.transform;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.sns.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * CreatePlatformApplicationResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreatePlatformApplicationResponseUnmarshaller implements
        Unmarshaller<CreatePlatformApplicationResponse, StaxUnmarshallerContext> {

    public CreatePlatformApplicationResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        CreatePlatformApplicationResponse.Builder createPlatformApplicationResponse = CreatePlatformApplicationResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("PlatformApplicationArn", targetDepth)) {
                    createPlatformApplicationResponse
                            .platformApplicationArn(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    break;
                }
            }
        }
        return createPlatformApplicationResponse.build();
    }

    private static CreatePlatformApplicationResponseUnmarshaller INSTANCE;

    public static CreatePlatformApplicationResponseUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new CreatePlatformApplicationResponseUnmarshaller();
        return INSTANCE;
    }
}