/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.transform;

import java.util.Map;
import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.sns.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * PublishRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PublishRequestMarshaller implements Marshaller<Request<PublishRequest>, PublishRequest> {

    public Request<PublishRequest> marshall(PublishRequest publishRequest) {

        if (publishRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<PublishRequest> request = new DefaultRequest<PublishRequest>(publishRequest, "SNSClient");
        request.addParameter("Action", "Publish");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);

        if (publishRequest.topicArn() != null) {
            request.addParameter("TopicArn", StringUtils.fromString(publishRequest.topicArn()));
        }

        if (publishRequest.targetArn() != null) {
            request.addParameter("TargetArn", StringUtils.fromString(publishRequest.targetArn()));
        }

        if (publishRequest.phoneNumber() != null) {
            request.addParameter("PhoneNumber", StringUtils.fromString(publishRequest.phoneNumber()));
        }

        if (publishRequest.message() != null) {
            request.addParameter("Message", StringUtils.fromString(publishRequest.message()));
        }

        if (publishRequest.subject() != null) {
            request.addParameter("Subject", StringUtils.fromString(publishRequest.subject()));
        }

        if (publishRequest.messageStructure() != null) {
            request.addParameter("MessageStructure", StringUtils.fromString(publishRequest.messageStructure()));
        }

        java.util.Map<String, MessageAttributeValue> messageAttributes = publishRequest.messageAttributes();
        int messageAttributesListIndex = 1;
        for (Map.Entry<String, MessageAttributeValue> entry : messageAttributes.entrySet()) {
            if (entry.getKey() != null) {
                request.addParameter("MessageAttributes.entry." + messageAttributesListIndex + ".Name",
                        StringUtils.fromString(entry.getKey()));
            }
            if (entry.getValue() != null) {

                if (entry.getValue().dataType() != null) {
                    request.addParameter("MessageAttributes.entry." + messageAttributesListIndex + ".Value.DataType",
                            StringUtils.fromString(entry.getValue().dataType()));
                }

                if (entry.getValue().stringValue() != null) {
                    request.addParameter("MessageAttributes.entry." + messageAttributesListIndex + ".Value.StringValue",
                            StringUtils.fromString(entry.getValue().stringValue()));
                }

                if (entry.getValue().binaryValue() != null) {
                    request.addParameter("MessageAttributes.entry." + messageAttributesListIndex + ".Value.BinaryValue",
                            StringUtils.fromByteBuffer(entry.getValue().binaryValue()));
                }
            }
            messageAttributesListIndex++;
        }

        return request;
    }

}
