/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalMap;
import software.amazon.awssdk.services.sns.model.MapStringToStringCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreatePlatformApplicationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreatePlatformApplicationRequest> {
    private final String name;
    private final String platform;
    private final Map<String, String> attributes;

    private CreatePlatformApplicationRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.platform = builder.platform;
        this.attributes = builder.attributes;
    }

    public String name() {
        return this.name;
    }

    public String platform() {
        return this.platform;
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.platform() == null ? 0 : this.platform().hashCode());
        hashCode = 31 * hashCode + (this.attributes() == null ? 0 : this.attributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlatformApplicationRequest)) {
            return false;
        }
        CreatePlatformApplicationRequest other = (CreatePlatformApplicationRequest)((Object)obj);
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.platform() == null ^ this.platform() == null) {
            return false;
        }
        if (other.platform() != null && !other.platform().equals(this.platform())) {
            return false;
        }
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        return other.attributes() == null || other.attributes().equals(this.attributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.platform() != null) {
            sb.append("Platform: ").append(this.platform()).append(",");
        }
        if (this.attributes() != null) {
            sb.append("Attributes: ").append(this.attributes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private String platform;
        private Map<String, String> attributes = new SdkInternalMap();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlatformApplicationRequest model) {
            this.setName(model.name);
            this.setPlatform(model.platform);
            this.setAttributes(model.attributes);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
        }

        public CreatePlatformApplicationRequest build() {
            return new CreatePlatformApplicationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreatePlatformApplicationRequest> {
        public Builder name(String var1);

        public Builder platform(String var1);

        public Builder attributes(Map<String, String> var1);
    }
}

