/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.sns.model.SetPlatformApplicationAttributesRequest;
import software.amazon.awssdk.util.StringUtils;

public class SetPlatformApplicationAttributesRequestMarshaller
implements Marshaller<Request<SetPlatformApplicationAttributesRequest>, SetPlatformApplicationAttributesRequest> {
    public Request<SetPlatformApplicationAttributesRequest> marshall(SetPlatformApplicationAttributesRequest setPlatformApplicationAttributesRequest) {
        if (setPlatformApplicationAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setPlatformApplicationAttributesRequest, "SNSClient");
        request.addParameter("Action", "SetPlatformApplicationAttributes");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (setPlatformApplicationAttributesRequest.platformApplicationArn() != null) {
            request.addParameter("PlatformApplicationArn", StringUtils.fromString((String)setPlatformApplicationAttributesRequest.platformApplicationArn()));
        }
        Map<String, String> attributes = setPlatformApplicationAttributesRequest.attributes();
        int attributesListIndex = 1;
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            if (entry.getKey() != null) {
                request.addParameter("Attributes.entry." + attributesListIndex + ".key", StringUtils.fromString((String)entry.getKey()));
            }
            if (entry.getValue() != null) {
                request.addParameter("Attributes.entry." + attributesListIndex + ".value", StringUtils.fromString((String)entry.getValue()));
            }
            ++attributesListIndex;
        }
        return request;
    }
}

