/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response from the <code>GetSMSAttributes</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetSMSAttributesResponse extends SNSResponse implements
        ToCopyableBuilder<GetSMSAttributesResponse.Builder, GetSMSAttributesResponse> {
    private final Map<String, String> attributes;

    private GetSMSAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * The SMS attribute names and their values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The SMS attribute names and their values.
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSMSAttributesResponse)) {
            return false;
        }
        GetSMSAttributesResponse other = (GetSMSAttributesResponse) obj;
        return Objects.equals(attributes(), other.attributes());
    }

    @Override
    public String toString() {
        return ToString.builder("GetSMSAttributesResponse").add("Attributes", attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attributes":
            return Optional.of(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SNSResponse.Builder, CopyableBuilder<Builder, GetSMSAttributesResponse> {
        /**
         * <p>
         * The SMS attribute names and their values.
         * </p>
         * 
         * @param attributes
         *        The SMS attribute names and their values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);
    }

    static final class BuilderImpl extends SNSResponse.BuilderImpl implements Builder {
        private Map<String, String> attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSMSAttributesResponse model) {
            super(model);
            attributes(model.attributes);
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
        }

        @Override
        public GetSMSAttributesResponse build() {
            return new GetSMSAttributesResponse(this);
        }
    }
}
