/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for the OptInPhoneNumber action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class OptInPhoneNumberRequest extends SNSRequest implements
        ToCopyableBuilder<OptInPhoneNumberRequest.Builder, OptInPhoneNumberRequest> {
    private final String phoneNumber;

    private OptInPhoneNumberRequest(BuilderImpl builder) {
        super(builder);
        this.phoneNumber = builder.phoneNumber;
    }

    /**
     * <p>
     * The phone number to opt in.
     * </p>
     * 
     * @return The phone number to opt in.
     */
    public String phoneNumber() {
        return phoneNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptInPhoneNumberRequest)) {
            return false;
        }
        OptInPhoneNumberRequest other = (OptInPhoneNumberRequest) obj;
        return Objects.equals(phoneNumber(), other.phoneNumber());
    }

    @Override
    public String toString() {
        return ToString.builder("OptInPhoneNumberRequest").add("PhoneNumber", phoneNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "phoneNumber":
            return Optional.of(clazz.cast(phoneNumber()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SNSRequest.Builder, CopyableBuilder<Builder, OptInPhoneNumberRequest> {
        /**
         * <p>
         * The phone number to opt in.
         * </p>
         * 
         * @param phoneNumber
         *        The phone number to opt in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(String phoneNumber);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SNSRequest.BuilderImpl implements Builder {
        private String phoneNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(OptInPhoneNumberRequest model) {
            super(model);
            phoneNumber(model.phoneNumber);
        }

        public final String getPhoneNumber() {
            return phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public OptInPhoneNumberRequest build() {
            return new OptInPhoneNumberRequest(this);
        }
    }
}
