/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Response for Publish action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PublishResponse extends SNSResponse implements ToCopyableBuilder<PublishResponse.Builder, PublishResponse> {
    private final String messageId;

    private PublishResponse(BuilderImpl builder) {
        super(builder);
        this.messageId = builder.messageId;
    }

    /**
     * <p>
     * Unique identifier assigned to the published message.
     * </p>
     * <p>
     * Length Constraint: Maximum 100 characters
     * </p>
     * 
     * @return Unique identifier assigned to the published message.</p>
     *         <p>
     *         Length Constraint: Maximum 100 characters
     */
    public String messageId() {
        return messageId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(messageId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishResponse)) {
            return false;
        }
        PublishResponse other = (PublishResponse) obj;
        return Objects.equals(messageId(), other.messageId());
    }

    @Override
    public String toString() {
        return ToString.builder("PublishResponse").add("MessageId", messageId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MessageId":
            return Optional.of(clazz.cast(messageId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SNSResponse.Builder, CopyableBuilder<Builder, PublishResponse> {
        /**
         * <p>
         * Unique identifier assigned to the published message.
         * </p>
         * <p>
         * Length Constraint: Maximum 100 characters
         * </p>
         * 
         * @param messageId
         *        Unique identifier assigned to the published message.</p>
         *        <p>
         *        Length Constraint: Maximum 100 characters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageId(String messageId);
    }

    static final class BuilderImpl extends SNSResponse.BuilderImpl implements Builder {
        private String messageId;

        private BuilderImpl() {
        }

        private BuilderImpl(PublishResponse model) {
            super(model);
            messageId(model.messageId);
        }

        public final String getMessageId() {
            return messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public PublishResponse build() {
            return new PublishResponse(this);
        }
    }
}
