/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for SetEndpointAttributes action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SetEndpointAttributesRequest extends SNSRequest implements
        ToCopyableBuilder<SetEndpointAttributesRequest.Builder, SetEndpointAttributesRequest> {
    private final String endpointArn;

    private final Map<String, String> attributes;

    private SetEndpointAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.endpointArn = builder.endpointArn;
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * EndpointArn used for SetEndpointAttributes action.
     * </p>
     * 
     * @return EndpointArn used for SetEndpointAttributes action.
     */
    public String endpointArn() {
        return endpointArn;
    }

    /**
     * <p>
     * A map of the endpoint attributes. Attributes in this map include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CustomUserData</code> -- arbitrary user data to associate with the endpoint. Amazon SNS does not use this
     * data. The data must be in UTF-8 format and less than 2KB.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Enabled</code> -- flag that enables/disables delivery to the endpoint. Amazon SNS will set this to false
     * when a notification service indicates to Amazon SNS that the endpoint is invalid. Users can set it back to true,
     * typically after updating Token.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Token</code> -- device token, also referred to as a registration id, for an app and mobile device. This is
     * returned from the notification service when an app and mobile device are registered with the notification
     * service.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A map of the endpoint attributes. Attributes in this map include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CustomUserData</code> -- arbitrary user data to associate with the endpoint. Amazon SNS does not
     *         use this data. The data must be in UTF-8 format and less than 2KB.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Enabled</code> -- flag that enables/disables delivery to the endpoint. Amazon SNS will set this to
     *         false when a notification service indicates to Amazon SNS that the endpoint is invalid. Users can set it
     *         back to true, typically after updating Token.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Token</code> -- device token, also referred to as a registration id, for an app and mobile device.
     *         This is returned from the notification service when an app and mobile device are registered with the
     *         notification service.
     *         </p>
     *         </li>
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetEndpointAttributesRequest)) {
            return false;
        }
        SetEndpointAttributesRequest other = (SetEndpointAttributesRequest) obj;
        return Objects.equals(endpointArn(), other.endpointArn()) && Objects.equals(attributes(), other.attributes());
    }

    @Override
    public String toString() {
        return ToString.builder("SetEndpointAttributesRequest").add("EndpointArn", endpointArn()).add("Attributes", attributes())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointArn":
            return Optional.of(clazz.cast(endpointArn()));
        case "Attributes":
            return Optional.of(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SNSRequest.Builder, CopyableBuilder<Builder, SetEndpointAttributesRequest> {
        /**
         * <p>
         * EndpointArn used for SetEndpointAttributes action.
         * </p>
         * 
         * @param endpointArn
         *        EndpointArn used for SetEndpointAttributes action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointArn(String endpointArn);

        /**
         * <p>
         * A map of the endpoint attributes. Attributes in this map include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CustomUserData</code> -- arbitrary user data to associate with the endpoint. Amazon SNS does not use
         * this data. The data must be in UTF-8 format and less than 2KB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Enabled</code> -- flag that enables/disables delivery to the endpoint. Amazon SNS will set this to
         * false when a notification service indicates to Amazon SNS that the endpoint is invalid. Users can set it back
         * to true, typically after updating Token.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Token</code> -- device token, also referred to as a registration id, for an app and mobile device. This
         * is returned from the notification service when an app and mobile device are registered with the notification
         * service.
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributes
         *        A map of the endpoint attributes. Attributes in this map include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CustomUserData</code> -- arbitrary user data to associate with the endpoint. Amazon SNS does not
         *        use this data. The data must be in UTF-8 format and less than 2KB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Enabled</code> -- flag that enables/disables delivery to the endpoint. Amazon SNS will set this
         *        to false when a notification service indicates to Amazon SNS that the endpoint is invalid. Users can
         *        set it back to true, typically after updating Token.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Token</code> -- device token, also referred to as a registration id, for an app and mobile
         *        device. This is returned from the notification service when an app and mobile device are registered
         *        with the notification service.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SNSRequest.BuilderImpl implements Builder {
        private String endpointArn;

        private Map<String, String> attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(SetEndpointAttributesRequest model) {
            super(model);
            endpointArn(model.endpointArn);
            attributes(model.attributes);
        }

        public final String getEndpointArn() {
            return endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SetEndpointAttributesRequest build() {
            return new SetEndpointAttributesRequest(this);
        }
    }
}
