/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for SetPlatformApplicationAttributes action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SetPlatformApplicationAttributesRequest extends SNSRequest implements
        ToCopyableBuilder<SetPlatformApplicationAttributesRequest.Builder, SetPlatformApplicationAttributesRequest> {
    private final String platformApplicationArn;

    private final Map<String, String> attributes;

    private SetPlatformApplicationAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.platformApplicationArn = builder.platformApplicationArn;
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * PlatformApplicationArn for SetPlatformApplicationAttributes action.
     * </p>
     * 
     * @return PlatformApplicationArn for SetPlatformApplicationAttributes action.
     */
    public String platformApplicationArn() {
        return platformApplicationArn;
    }

    /**
     * <p>
     * A map of the platform application attributes. Attributes in this map include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PlatformCredential</code> -- The credential received from the notification service. For APNS/APNS_SANDBOX,
     * PlatformCredential is private key. For GCM, PlatformCredential is "API key". For ADM, PlatformCredential is
     * "client secret".
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PlatformPrincipal</code> -- The principal received from the notification service. For APNS/APNS_SANDBOX,
     * PlatformPrincipal is SSL certificate. For GCM, PlatformPrincipal is not applicable. For ADM, PlatformPrincipal is
     * "client id".
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EventEndpointCreated</code> -- Topic ARN to which EndpointCreated event notifications should be sent.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EventEndpointDeleted</code> -- Topic ARN to which EndpointDeleted event notifications should be sent.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EventEndpointUpdated</code> -- Topic ARN to which EndpointUpdate event notifications should be sent.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EventDeliveryFailure</code> -- Topic ARN to which DeliveryFailure event notifications should be sent upon
     * Direct Publish delivery failure (permanent) to one of the application's endpoints.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SuccessFeedbackRoleArn</code> -- IAM role ARN used to give Amazon SNS write access to use CloudWatch Logs
     * on your behalf.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FailureFeedbackRoleArn</code> -- IAM role ARN used to give Amazon SNS write access to use CloudWatch Logs
     * on your behalf.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SuccessFeedbackSampleRate</code> -- Sample rate percentage (0-100) of successfully delivered messages.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A map of the platform application attributes. Attributes in this map include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PlatformCredential</code> -- The credential received from the notification service. For
     *         APNS/APNS_SANDBOX, PlatformCredential is private key. For GCM, PlatformCredential is "API key". For ADM,
     *         PlatformCredential is "client secret".
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PlatformPrincipal</code> -- The principal received from the notification service. For
     *         APNS/APNS_SANDBOX, PlatformPrincipal is SSL certificate. For GCM, PlatformPrincipal is not applicable.
     *         For ADM, PlatformPrincipal is "client id".
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EventEndpointCreated</code> -- Topic ARN to which EndpointCreated event notifications should be
     *         sent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EventEndpointDeleted</code> -- Topic ARN to which EndpointDeleted event notifications should be
     *         sent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EventEndpointUpdated</code> -- Topic ARN to which EndpointUpdate event notifications should be
     *         sent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EventDeliveryFailure</code> -- Topic ARN to which DeliveryFailure event notifications should be
     *         sent upon Direct Publish delivery failure (permanent) to one of the application's endpoints.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SuccessFeedbackRoleArn</code> -- IAM role ARN used to give Amazon SNS write access to use
     *         CloudWatch Logs on your behalf.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FailureFeedbackRoleArn</code> -- IAM role ARN used to give Amazon SNS write access to use
     *         CloudWatch Logs on your behalf.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SuccessFeedbackSampleRate</code> -- Sample rate percentage (0-100) of successfully delivered
     *         messages.
     *         </p>
     *         </li>
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(platformApplicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetPlatformApplicationAttributesRequest)) {
            return false;
        }
        SetPlatformApplicationAttributesRequest other = (SetPlatformApplicationAttributesRequest) obj;
        return Objects.equals(platformApplicationArn(), other.platformApplicationArn())
                && Objects.equals(attributes(), other.attributes());
    }

    @Override
    public String toString() {
        return ToString.builder("SetPlatformApplicationAttributesRequest")
                .add("PlatformApplicationArn", platformApplicationArn()).add("Attributes", attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlatformApplicationArn":
            return Optional.of(clazz.cast(platformApplicationArn()));
        case "Attributes":
            return Optional.of(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SNSRequest.Builder, CopyableBuilder<Builder, SetPlatformApplicationAttributesRequest> {
        /**
         * <p>
         * PlatformApplicationArn for SetPlatformApplicationAttributes action.
         * </p>
         * 
         * @param platformApplicationArn
         *        PlatformApplicationArn for SetPlatformApplicationAttributes action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformApplicationArn(String platformApplicationArn);

        /**
         * <p>
         * A map of the platform application attributes. Attributes in this map include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PlatformCredential</code> -- The credential received from the notification service. For
         * APNS/APNS_SANDBOX, PlatformCredential is private key. For GCM, PlatformCredential is "API key". For ADM,
         * PlatformCredential is "client secret".
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PlatformPrincipal</code> -- The principal received from the notification service. For
         * APNS/APNS_SANDBOX, PlatformPrincipal is SSL certificate. For GCM, PlatformPrincipal is not applicable. For
         * ADM, PlatformPrincipal is "client id".
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EventEndpointCreated</code> -- Topic ARN to which EndpointCreated event notifications should be sent.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EventEndpointDeleted</code> -- Topic ARN to which EndpointDeleted event notifications should be sent.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EventEndpointUpdated</code> -- Topic ARN to which EndpointUpdate event notifications should be sent.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EventDeliveryFailure</code> -- Topic ARN to which DeliveryFailure event notifications should be sent
         * upon Direct Publish delivery failure (permanent) to one of the application's endpoints.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SuccessFeedbackRoleArn</code> -- IAM role ARN used to give Amazon SNS write access to use CloudWatch
         * Logs on your behalf.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FailureFeedbackRoleArn</code> -- IAM role ARN used to give Amazon SNS write access to use CloudWatch
         * Logs on your behalf.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SuccessFeedbackSampleRate</code> -- Sample rate percentage (0-100) of successfully delivered messages.
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributes
         *        A map of the platform application attributes. Attributes in this map include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PlatformCredential</code> -- The credential received from the notification service. For
         *        APNS/APNS_SANDBOX, PlatformCredential is private key. For GCM, PlatformCredential is "API key". For
         *        ADM, PlatformCredential is "client secret".
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PlatformPrincipal</code> -- The principal received from the notification service. For
         *        APNS/APNS_SANDBOX, PlatformPrincipal is SSL certificate. For GCM, PlatformPrincipal is not applicable.
         *        For ADM, PlatformPrincipal is "client id".
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EventEndpointCreated</code> -- Topic ARN to which EndpointCreated event notifications should be
         *        sent.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EventEndpointDeleted</code> -- Topic ARN to which EndpointDeleted event notifications should be
         *        sent.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EventEndpointUpdated</code> -- Topic ARN to which EndpointUpdate event notifications should be
         *        sent.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EventDeliveryFailure</code> -- Topic ARN to which DeliveryFailure event notifications should be
         *        sent upon Direct Publish delivery failure (permanent) to one of the application's endpoints.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SuccessFeedbackRoleArn</code> -- IAM role ARN used to give Amazon SNS write access to use
         *        CloudWatch Logs on your behalf.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FailureFeedbackRoleArn</code> -- IAM role ARN used to give Amazon SNS write access to use
         *        CloudWatch Logs on your behalf.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SuccessFeedbackSampleRate</code> -- Sample rate percentage (0-100) of successfully delivered
         *        messages.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SNSRequest.BuilderImpl implements Builder {
        private String platformApplicationArn;

        private Map<String, String> attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(SetPlatformApplicationAttributesRequest model) {
            super(model);
            platformApplicationArn(model.platformApplicationArn);
            attributes(model.attributes);
        }

        public final String getPlatformApplicationArn() {
            return platformApplicationArn;
        }

        @Override
        public final Builder platformApplicationArn(String platformApplicationArn) {
            this.platformApplicationArn = platformApplicationArn;
            return this;
        }

        public final void setPlatformApplicationArn(String platformApplicationArn) {
            this.platformApplicationArn = platformApplicationArn;
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SetPlatformApplicationAttributesRequest build() {
            return new SetPlatformApplicationAttributesRequest(this);
        }
    }
}
