/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for Subscribe action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SubscribeRequest extends SNSRequest implements ToCopyableBuilder<SubscribeRequest.Builder, SubscribeRequest> {
    private final String topicArn;

    private final String protocol;

    private final String endpoint;

    private SubscribeRequest(BuilderImpl builder) {
        super(builder);
        this.topicArn = builder.topicArn;
        this.protocol = builder.protocol;
        this.endpoint = builder.endpoint;
    }

    /**
     * <p>
     * The ARN of the topic you want to subscribe to.
     * </p>
     * 
     * @return The ARN of the topic you want to subscribe to.
     */
    public String topicArn() {
        return topicArn;
    }

    /**
     * <p>
     * The protocol you want to use. Supported protocols include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>http</code> -- delivery of JSON-encoded message via HTTP POST
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>https</code> -- delivery of JSON-encoded message via HTTPS POST
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>email</code> -- delivery of message via SMTP
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>email-json</code> -- delivery of JSON-encoded message via SMTP
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sms</code> -- delivery of message via SMS
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sqs</code> -- delivery of JSON-encoded message to an Amazon SQS queue
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>application</code> -- delivery of JSON-encoded message to an EndpointArn for a mobile app and device.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>lambda</code> -- delivery of JSON-encoded message to an AWS Lambda function.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The protocol you want to use. Supported protocols include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>http</code> -- delivery of JSON-encoded message via HTTP POST
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>https</code> -- delivery of JSON-encoded message via HTTPS POST
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>email</code> -- delivery of message via SMTP
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>email-json</code> -- delivery of JSON-encoded message via SMTP
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sms</code> -- delivery of message via SMS
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sqs</code> -- delivery of JSON-encoded message to an Amazon SQS queue
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>application</code> -- delivery of JSON-encoded message to an EndpointArn for a mobile app and
     *         device.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>lambda</code> -- delivery of JSON-encoded message to an AWS Lambda function.
     *         </p>
     *         </li>
     */
    public String protocol() {
        return protocol;
    }

    /**
     * <p>
     * The endpoint that you want to receive notifications. Endpoints vary by protocol:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For the <code>http</code> protocol, the endpoint is an URL beginning with "http://"
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>https</code> protocol, the endpoint is a URL beginning with "https://"
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>email</code> protocol, the endpoint is an email address
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>email-json</code> protocol, the endpoint is an email address
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>sms</code> protocol, the endpoint is a phone number of an SMS-enabled device
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>sqs</code> protocol, the endpoint is the ARN of an Amazon SQS queue
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>application</code> protocol, the endpoint is the EndpointArn of a mobile app and device.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>lambda</code> protocol, the endpoint is the ARN of an AWS Lambda function.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The endpoint that you want to receive notifications. Endpoints vary by protocol:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For the <code>http</code> protocol, the endpoint is an URL beginning with "http://"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>https</code> protocol, the endpoint is a URL beginning with "https://"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>email</code> protocol, the endpoint is an email address
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>email-json</code> protocol, the endpoint is an email address
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>sms</code> protocol, the endpoint is a phone number of an SMS-enabled device
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>sqs</code> protocol, the endpoint is the ARN of an Amazon SQS queue
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>application</code> protocol, the endpoint is the EndpointArn of a mobile app and device.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>lambda</code> protocol, the endpoint is the ARN of an AWS Lambda function.
     *         </p>
     *         </li>
     */
    public String endpoint() {
        return endpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscribeRequest)) {
            return false;
        }
        SubscribeRequest other = (SubscribeRequest) obj;
        return Objects.equals(topicArn(), other.topicArn()) && Objects.equals(protocol(), other.protocol())
                && Objects.equals(endpoint(), other.endpoint());
    }

    @Override
    public String toString() {
        return ToString.builder("SubscribeRequest").add("TopicArn", topicArn()).add("Protocol", protocol())
                .add("Endpoint", endpoint()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TopicArn":
            return Optional.of(clazz.cast(topicArn()));
        case "Protocol":
            return Optional.of(clazz.cast(protocol()));
        case "Endpoint":
            return Optional.of(clazz.cast(endpoint()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SNSRequest.Builder, CopyableBuilder<Builder, SubscribeRequest> {
        /**
         * <p>
         * The ARN of the topic you want to subscribe to.
         * </p>
         * 
         * @param topicArn
         *        The ARN of the topic you want to subscribe to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicArn(String topicArn);

        /**
         * <p>
         * The protocol you want to use. Supported protocols include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>http</code> -- delivery of JSON-encoded message via HTTP POST
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>https</code> -- delivery of JSON-encoded message via HTTPS POST
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>email</code> -- delivery of message via SMTP
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>email-json</code> -- delivery of JSON-encoded message via SMTP
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sms</code> -- delivery of message via SMS
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sqs</code> -- delivery of JSON-encoded message to an Amazon SQS queue
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>application</code> -- delivery of JSON-encoded message to an EndpointArn for a mobile app and device.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>lambda</code> -- delivery of JSON-encoded message to an AWS Lambda function.
         * </p>
         * </li>
         * </ul>
         * 
         * @param protocol
         *        The protocol you want to use. Supported protocols include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>http</code> -- delivery of JSON-encoded message via HTTP POST
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>https</code> -- delivery of JSON-encoded message via HTTPS POST
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>email</code> -- delivery of message via SMTP
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>email-json</code> -- delivery of JSON-encoded message via SMTP
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sms</code> -- delivery of message via SMS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sqs</code> -- delivery of JSON-encoded message to an Amazon SQS queue
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>application</code> -- delivery of JSON-encoded message to an EndpointArn for a mobile app and
         *        device.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>lambda</code> -- delivery of JSON-encoded message to an AWS Lambda function.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The endpoint that you want to receive notifications. Endpoints vary by protocol:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For the <code>http</code> protocol, the endpoint is an URL beginning with "http://"
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>https</code> protocol, the endpoint is a URL beginning with "https://"
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>email</code> protocol, the endpoint is an email address
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>email-json</code> protocol, the endpoint is an email address
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>sms</code> protocol, the endpoint is a phone number of an SMS-enabled device
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>sqs</code> protocol, the endpoint is the ARN of an Amazon SQS queue
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>application</code> protocol, the endpoint is the EndpointArn of a mobile app and device.
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>lambda</code> protocol, the endpoint is the ARN of an AWS Lambda function.
         * </p>
         * </li>
         * </ul>
         * 
         * @param endpoint
         *        The endpoint that you want to receive notifications. Endpoints vary by protocol:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For the <code>http</code> protocol, the endpoint is an URL beginning with "http://"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>https</code> protocol, the endpoint is a URL beginning with "https://"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>email</code> protocol, the endpoint is an email address
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>email-json</code> protocol, the endpoint is an email address
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>sms</code> protocol, the endpoint is a phone number of an SMS-enabled device
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>sqs</code> protocol, the endpoint is the ARN of an Amazon SQS queue
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>application</code> protocol, the endpoint is the EndpointArn of a mobile app and device.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>lambda</code> protocol, the endpoint is the ARN of an AWS Lambda function.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SNSRequest.BuilderImpl implements Builder {
        private String topicArn;

        private String protocol;

        private String endpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(SubscribeRequest model) {
            super(model);
            topicArn(model.topicArn);
            protocol(model.protocol);
            endpoint(model.endpoint);
        }

        public final String getTopicArn() {
            return topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final String getProtocol() {
            return protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SubscribeRequest build() {
            return new SubscribeRequest(this);
        }
    }
}
