/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Response from CreatePlatformApplication action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePlatformApplicationResponse extends SnsResponse implements
        ToCopyableBuilder<CreatePlatformApplicationResponse.Builder, CreatePlatformApplicationResponse> {
    private final String platformApplicationArn;

    private CreatePlatformApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.platformApplicationArn = builder.platformApplicationArn;
    }

    /**
     * <p>
     * PlatformApplicationArn is returned.
     * </p>
     * 
     * @return PlatformApplicationArn is returned.
     */
    public String platformApplicationArn() {
        return platformApplicationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(platformApplicationArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlatformApplicationResponse)) {
            return false;
        }
        CreatePlatformApplicationResponse other = (CreatePlatformApplicationResponse) obj;
        return Objects.equals(platformApplicationArn(), other.platformApplicationArn());
    }

    @Override
    public String toString() {
        return ToString.builder("CreatePlatformApplicationResponse").add("PlatformApplicationArn", platformApplicationArn())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlatformApplicationArn":
            return Optional.ofNullable(clazz.cast(platformApplicationArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SnsResponse.Builder, CopyableBuilder<Builder, CreatePlatformApplicationResponse> {
        /**
         * <p>
         * PlatformApplicationArn is returned.
         * </p>
         * 
         * @param platformApplicationArn
         *        PlatformApplicationArn is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformApplicationArn(String platformApplicationArn);
    }

    static final class BuilderImpl extends SnsResponse.BuilderImpl implements Builder {
        private String platformApplicationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlatformApplicationResponse model) {
            super(model);
            platformApplicationArn(model.platformApplicationArn);
        }

        public final String getPlatformApplicationArn() {
            return platformApplicationArn;
        }

        @Override
        public final Builder platformApplicationArn(String platformApplicationArn) {
            this.platformApplicationArn = platformApplicationArn;
            return this;
        }

        public final void setPlatformApplicationArn(String platformApplicationArn) {
            this.platformApplicationArn = platformApplicationArn;
        }

        @Override
        public CreatePlatformApplicationResponse build() {
            return new CreatePlatformApplicationResponse(this);
        }
    }
}
