/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Response for GetSubscriptionAttributes action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSubscriptionAttributesResponse extends SnsResponse implements
        ToCopyableBuilder<GetSubscriptionAttributesResponse.Builder, GetSubscriptionAttributesResponse> {
    private final Map<String, String> attributes;

    private GetSubscriptionAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * A map of the subscription's attributes. Attributes in this map include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SubscriptionArn</code> -- the subscription's ARN
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TopicArn</code> -- the topic ARN that the subscription is associated with
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Owner</code> -- the AWS account ID of the subscription's owner
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ConfirmationWasAuthenticated</code> -- true if the subscription confirmation request was authenticated
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DeliveryPolicy</code> -- the JSON serialization of the subscription's delivery policy
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EffectiveDeliveryPolicy</code> -- the JSON serialization of the effective delivery policy that takes into
     * account the topic delivery policy and account system defaults
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A map of the subscription's attributes. Attributes in this map include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SubscriptionArn</code> -- the subscription's ARN
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TopicArn</code> -- the topic ARN that the subscription is associated with
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Owner</code> -- the AWS account ID of the subscription's owner
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ConfirmationWasAuthenticated</code> -- true if the subscription confirmation request was
     *         authenticated
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DeliveryPolicy</code> -- the JSON serialization of the subscription's delivery policy
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EffectiveDeliveryPolicy</code> -- the JSON serialization of the effective delivery policy that
     *         takes into account the topic delivery policy and account system defaults
     *         </p>
     *         </li>
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSubscriptionAttributesResponse)) {
            return false;
        }
        GetSubscriptionAttributesResponse other = (GetSubscriptionAttributesResponse) obj;
        return Objects.equals(attributes(), other.attributes());
    }

    @Override
    public String toString() {
        return ToString.builder("GetSubscriptionAttributesResponse").add("Attributes", attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SnsResponse.Builder, CopyableBuilder<Builder, GetSubscriptionAttributesResponse> {
        /**
         * <p>
         * A map of the subscription's attributes. Attributes in this map include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SubscriptionArn</code> -- the subscription's ARN
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TopicArn</code> -- the topic ARN that the subscription is associated with
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Owner</code> -- the AWS account ID of the subscription's owner
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ConfirmationWasAuthenticated</code> -- true if the subscription confirmation request was authenticated
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DeliveryPolicy</code> -- the JSON serialization of the subscription's delivery policy
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EffectiveDeliveryPolicy</code> -- the JSON serialization of the effective delivery policy that takes
         * into account the topic delivery policy and account system defaults
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributes
         *        A map of the subscription's attributes. Attributes in this map include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SubscriptionArn</code> -- the subscription's ARN
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TopicArn</code> -- the topic ARN that the subscription is associated with
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Owner</code> -- the AWS account ID of the subscription's owner
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ConfirmationWasAuthenticated</code> -- true if the subscription confirmation request was
         *        authenticated
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DeliveryPolicy</code> -- the JSON serialization of the subscription's delivery policy
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EffectiveDeliveryPolicy</code> -- the JSON serialization of the effective delivery policy that
         *        takes into account the topic delivery policy and account system defaults
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);
    }

    static final class BuilderImpl extends SnsResponse.BuilderImpl implements Builder {
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSubscriptionAttributesResponse model) {
            super(model);
            attributes(model.attributes);
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = SubscriptionAttributesMapCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = SubscriptionAttributesMapCopier.copy(attributes);
        }

        @Override
        public GetSubscriptionAttributesResponse build() {
            return new GetSubscriptionAttributesResponse(this);
        }
    }
}
