/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.transform;

import java.util.Map;
import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.sns.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * PublishRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PublishRequestMarshaller implements Marshaller<Request<PublishRequest>, PublishRequest> {

    public Request<PublishRequest> marshall(PublishRequest publishRequest) {

        if (publishRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<PublishRequest> request = new DefaultRequest<PublishRequest>(publishRequest, "SnsClient");
        request.addParameter("Action", "Publish");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);

        if (publishRequest.topicArn() != null) {
            request.addParameter("TopicArn", StringConversion.fromString(publishRequest.topicArn()));
        }

        if (publishRequest.targetArn() != null) {
            request.addParameter("TargetArn", StringConversion.fromString(publishRequest.targetArn()));
        }

        if (publishRequest.phoneNumber() != null) {
            request.addParameter("PhoneNumber", StringConversion.fromString(publishRequest.phoneNumber()));
        }

        if (publishRequest.message() != null) {
            request.addParameter("Message", StringConversion.fromString(publishRequest.message()));
        }

        if (publishRequest.subject() != null) {
            request.addParameter("Subject", StringConversion.fromString(publishRequest.subject()));
        }

        if (publishRequest.messageStructure() != null) {
            request.addParameter("MessageStructure", StringConversion.fromString(publishRequest.messageStructure()));
        }

        java.util.Map<String, MessageAttributeValue> messageAttributes = publishRequest.messageAttributes();

        if (messageAttributes != null) {
            int messageAttributesListIndex = 1;
            for (Map.Entry<String, MessageAttributeValue> entry : messageAttributes.entrySet()) {
                if (entry.getKey() != null) {
                    request.addParameter("MessageAttributes.entry." + messageAttributesListIndex + ".Name",
                            StringConversion.fromString(entry.getKey()));
                }
                if (entry.getValue() != null) {

                    if (entry.getValue().dataType() != null) {
                        request.addParameter("MessageAttributes.entry." + messageAttributesListIndex + ".Value.DataType",
                                StringConversion.fromString(entry.getValue().dataType()));
                    }

                    if (entry.getValue().stringValue() != null) {
                        request.addParameter("MessageAttributes.entry." + messageAttributesListIndex + ".Value.StringValue",
                                StringConversion.fromString(entry.getValue().stringValue()));
                    }

                    if (entry.getValue().binaryValue() != null) {
                        request.addParameter("MessageAttributes.entry." + messageAttributesListIndex + ".Value.BinaryValue",
                                StringConversion.fromSdkBytes(entry.getValue().binaryValue()));
                    }
                }
                messageAttributesListIndex++;
            }
        }

        return request;
    }

}
