/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.model.ListPlatformApplicationsRequest;
import software.amazon.awssdk.services.sns.model.ListPlatformApplicationsResponse;
import software.amazon.awssdk.services.sns.model.PlatformApplication;

public class ListPlatformApplicationsIterable
implements SdkIterable<ListPlatformApplicationsResponse> {
    private final SnsClient client;
    private final ListPlatformApplicationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPlatformApplicationsIterable(SnsClient client, ListPlatformApplicationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPlatformApplicationsResponseFetcher();
    }

    public Iterator<ListPlatformApplicationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PlatformApplication> platformApplications() {
        Function<ListPlatformApplicationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.platformApplications() != null) {
                return response.platformApplications().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final ListPlatformApplicationsIterable resume(ListPlatformApplicationsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListPlatformApplicationsIterable(this.client, (ListPlatformApplicationsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListPlatformApplicationsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListPlatformApplicationsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListPlatformApplicationsResponseFetcher
    implements SyncPageFetcher<ListPlatformApplicationsResponse> {
        private ListPlatformApplicationsResponseFetcher() {
        }

        public boolean hasNextPage(ListPlatformApplicationsResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public ListPlatformApplicationsResponse nextPage(ListPlatformApplicationsResponse previousPage) {
            if (previousPage == null) {
                return ListPlatformApplicationsIterable.this.client.listPlatformApplications(ListPlatformApplicationsIterable.this.firstRequest);
            }
            return ListPlatformApplicationsIterable.this.client.listPlatformApplications((ListPlatformApplicationsRequest)((Object)ListPlatformApplicationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

