/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.sns.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * AddPermissionRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class AddPermissionRequestMarshaller implements Marshaller<Request<AddPermissionRequest>, AddPermissionRequest> {

    public Request<AddPermissionRequest> marshall(AddPermissionRequest addPermissionRequest) {

        if (addPermissionRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<AddPermissionRequest> request = new DefaultRequest<AddPermissionRequest>(addPermissionRequest, "SnsClient");
        request.addParameter("Action", "AddPermission");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);

        if (addPermissionRequest.topicArn() != null) {
            request.addParameter("TopicArn", StringConversion.fromString(addPermissionRequest.topicArn()));
        }

        if (addPermissionRequest.label() != null) {
            request.addParameter("Label", StringConversion.fromString(addPermissionRequest.label()));
        }

        if (addPermissionRequest.awsAccountIds().isEmpty()
                && !(addPermissionRequest.awsAccountIds() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("AWSAccountId", "");
        } else if (!addPermissionRequest.awsAccountIds().isEmpty()
                && !(addPermissionRequest.awsAccountIds() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> aWSAccountIdsList = addPermissionRequest.awsAccountIds();
            int aWSAccountIdsListIndex = 1;

            for (String aWSAccountIdsListValue : aWSAccountIdsList) {
                if (aWSAccountIdsListValue != null) {
                    request.addParameter("AWSAccountId.member." + aWSAccountIdsListIndex,
                            StringConversion.fromString(aWSAccountIdsListValue));
                }
                aWSAccountIdsListIndex++;
            }
        }

        if (addPermissionRequest.actionNames().isEmpty()
                && !(addPermissionRequest.actionNames() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("ActionName", "");
        } else if (!addPermissionRequest.actionNames().isEmpty()
                && !(addPermissionRequest.actionNames() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> actionNamesList = addPermissionRequest.actionNames();
            int actionNamesListIndex = 1;

            for (String actionNamesListValue : actionNamesList) {
                if (actionNamesListValue != null) {
                    request.addParameter("ActionName.member." + actionNamesListIndex,
                            StringConversion.fromString(actionNamesListValue));
                }
                actionNamesListIndex++;
            }
        }

        return request;
    }

}
