/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.sns.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * GetSmsAttributesRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetSmsAttributesRequestMarshaller implements Marshaller<Request<GetSmsAttributesRequest>, GetSmsAttributesRequest> {

    public Request<GetSmsAttributesRequest> marshall(GetSmsAttributesRequest getSmsAttributesRequest) {

        if (getSmsAttributesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<GetSmsAttributesRequest> request = new DefaultRequest<GetSmsAttributesRequest>(getSmsAttributesRequest,
                "SnsClient");
        request.addParameter("Action", "GetSMSAttributes");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);

        if (getSmsAttributesRequest.attributes().isEmpty()
                && !(getSmsAttributesRequest.attributes() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("attributes", "");
        } else if (!getSmsAttributesRequest.attributes().isEmpty()
                && !(getSmsAttributesRequest.attributes() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> attributesList = getSmsAttributesRequest.attributes();
            int attributesListIndex = 1;

            for (String attributesListValue : attributesList) {
                if (attributesListValue != null) {
                    request.addParameter("attributes.member." + attributesListIndex,
                            StringConversion.fromString(attributesListValue));
                }
                attributesListIndex++;
            }
        }

        return request;
    }

}
