/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.sns.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * ListEndpointsByPlatformApplicationResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListEndpointsByPlatformApplicationResponseUnmarshaller implements
        Unmarshaller<ListEndpointsByPlatformApplicationResponse, StaxUnmarshallerContext> {

    public ListEndpointsByPlatformApplicationResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListEndpointsByPlatformApplicationResponse.Builder listEndpointsByPlatformApplicationResponse = ListEndpointsByPlatformApplicationResponse
                .builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        java.util.List<Endpoint> endpoints = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                listEndpointsByPlatformApplicationResponse.endpoints(endpoints);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Endpoints", targetDepth)) {
                    endpoints = new ArrayList<Endpoint>();
                    continue;
                }

                if (context.testExpression("Endpoints/member", targetDepth)) {
                    endpoints.add(EndpointUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextToken", targetDepth)) {
                    listEndpointsByPlatformApplicationResponse.nextToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    listEndpointsByPlatformApplicationResponse.endpoints(endpoints);
                    break;
                }
            }
        }
        return listEndpointsByPlatformApplicationResponse.build();
    }

    private static final ListEndpointsByPlatformApplicationResponseUnmarshaller INSTANCE = new ListEndpointsByPlatformApplicationResponseUnmarshaller();

    public static ListEndpointsByPlatformApplicationResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
